/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.tree.Filter;
import tecgraf.javautils.gui.tree.Node;
import tecgraf.javautils.gui.tree.Tree;

public final class FilterableTreePanel
extends JPanel {
    private static final Border ERROR_BORDER = BorderFactory.createLineBorder(Color.RED, 2);
    private Border defaultTextFieldBorder;
    private JCheckBox ignoreCaseCheckBox;
    private Tree tree;
    private JTextField textField;
    private JCheckBox regexCheckBox;

    public FilterableTreePanel(Node root) {
        this.tree = new Tree(root, new Filter(){

            @Override
            public boolean isAccepted(Node node) {
                String label = node.getLabel();
                if (label == null) {
                    label = "";
                }
                String text = FilterableTreePanel.this.textField.getText();
                if (FilterableTreePanel.this.regexCheckBox.isSelected()) {
                    Pattern pattern = FilterableTreePanel.this.getRegexPattern();
                    if (pattern == null) {
                        return false;
                    }
                    Matcher matcher = pattern.matcher(label);
                    return matcher.find();
                }
                if (FilterableTreePanel.this.ignoreCaseCheckBox.isSelected()) {
                    label = label.toUpperCase();
                    text = text.toUpperCase();
                }
                return label.contains(text);
            }

            @Override
            public boolean isEnabled() {
                if (FilterableTreePanel.this.textField == null) {
                    return false;
                }
                String text = FilterableTreePanel.this.textField.getText();
                return text.length() != 0;
            }
        });
        this.textField = new JTextField();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterableTreePanel.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterableTreePanel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilterableTreePanel.this.update();
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                String text = FilterableTreePanel.this.textField.getText();
                if (text.length() != 0) {
                    FilterableTreePanel.this.textField.select(0, text.length());
                }
            }
        });
        this.defaultTextFieldBorder = this.textField.getBorder();
        this.ignoreCaseCheckBox = new JCheckBox(this.getMessage("ignoreCaseCheckBox.label"));
        this.ignoreCaseCheckBox.setSelected(true);
        this.ignoreCaseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterableTreePanel.this.update();
            }
        });
        this.regexCheckBox = new JCheckBox(this.getMessage("regexCheckBox.label"));
        this.regexCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterableTreePanel.this.update();
                if (FilterableTreePanel.this.regexCheckBox.isSelected()) {
                    FilterableTreePanel.this.ignoreCaseCheckBox.setEnabled(false);
                } else {
                    FilterableTreePanel.this.ignoreCaseCheckBox.setEnabled(true);
                }
            }
        });
        JPanel searchPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        searchPanel.add((Component)this.ignoreCaseCheckBox, constraints);
        ++constraints.gridy;
        searchPanel.add((Component)this.regexCheckBox, constraints);
        ++constraints.gridy;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        searchPanel.add((Component)this.textField, constraints);
        searchPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)searchPanel, "North");
        this.add((Component)new JScrollPane(this.tree, 22, 32), "Center");
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JTree getTree() {
        return this.tree;
    }

    private String getMessage(String suffixKey) {
        return LNG.get(this.getClass().getName() + "." + suffixKey);
    }

    private Pattern getRegexPattern() {
        String text = this.textField.getText();
        try {
            return Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private void update() {
        this.tree.filter();
        if (this.regexCheckBox.isSelected() && this.getRegexPattern() == null) {
            this.textField.setBorder(ERROR_BORDER);
            return;
        }
        this.textField.setBorder(this.defaultTextFieldBorder);
    }
}

