/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Collections;
import java.util.Map;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.LRUCache;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;

class IsValidCache {
    private Map<IsValidKey, Boolean> cache;
    private ConnectionImpl conn;

    IsValidCache(ConnectionImpl conn, int cacheSize) {
        this.conn = conn;
        this.cache = Collections.synchronizedMap(new LRUCache(cacheSize));
    }

    boolean isValid(Credential credential) {
        IsValidKey key = new IsValidKey(credential.identifier, credential.owner);
        Boolean valid = this.cache.get(key);
        if (valid == null) {
            if (this.conn.legacy()) {
                valid = this.conn.legacyAccess().isValid(credential);
                this.cache.put(key, valid);
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public void clear() {
        this.cache.clear();
    }

    private class IsValidKey {
        public String id;
        public String owner;

        public IsValidKey(String id, String owner) {
            this.id = id;
            this.owner = owner;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IsValidKey other = (IsValidKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
        }

        private IsValidCache getOuterType() {
            return IsValidCache.this;
        }
    }
}

