/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.certificates;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.certificates.CertificateWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class CertificateDeleteAction
extends OpenBusAction<CertificateWrapper> {
    public CertificateDeleteAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(CertificateDeleteAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title"), 0, 3);
        if (option != 0) {
            return;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                List certificates = CertificateDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (CertificateWrapper certificate : certificates) {
                    String entityId = certificate.getEntity();
                    CertificateDeleteAction.this.admin.removeCertificate(entityId);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CertificateDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

