/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.BusExplorerLogin;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.utils.BusAddress;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.ConfigurationProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;

public class LoginDialog
extends JDialog {
    JLabel labelHost = null;
    JLabel labelPort = null;
    private JComboBox comboBus;
    private JTextField fieldHost;
    private JTextField fieldPort;
    private JTextField fieldUser;
    private JPasswordField fieldPassword;
    private JButton buttonLogin;
    private BusExplorerLogin login;
    private BusAdmin admin;

    public LoginDialog(Window owner, BusAdmin admin) {
        super(owner, LNG.get("LoginDialog.title") + " - " + LNG.get("Application.title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.admin = admin;
        this.buildDialog();
    }

    private void buildDialog() {
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginDialog.this.getOwner().dispose();
                System.exit(0);
            }
        });
        this.buildLoginPane();
        this.setLocationRelativeTo(this.getOwner());
    }

    public BusExplorerLogin getLogin() {
        return this.login;
    }

    private void buildLoginPane() {
        JPanel loginPanel = new JPanel(new BorderLayout());
        loginPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel configPanel = new JPanel();
        GridBagLayout configLayout = new GridBagLayout();
        configLayout.columnWidths = new int[]{300, 120};
        configPanel.setLayout(configLayout);
        TitledBorder configBorder = new TitledBorder(null, LNG.get("LoginDialog.config.label"));
        configPanel.setBorder(configBorder);
        Font FONT_LABEL = new Font("Dialog", 0, 12);
        EnableLoginListener enableLoginListener = new EnableLoginListener();
        SelectAllTextListener selectAllTextListener = new SelectAllTextListener();
        ConfigurationProperties configProps = new ConfigurationProperties();
        Vector<BusAddress> busVector = new Vector<BusAddress>();
        int i = 1;
        while (true) {
            String busPrefix = "bus" + i + ".";
            String description = configProps.getProperty(busPrefix + "description");
            String address = configProps.getProperty(busPrefix + "address");
            if (description == null || address == null) break;
            busVector.add(new BusAddress(description, address));
            ++i;
        }
        this.fieldHost = new JTextField();
        this.fieldPort = new JTextField();
        if (busVector.size() > 0) {
            busVector.add(BusAddress.UNSPECIFIED_ADDRESS);
            JLabel labelBus = new JLabel(LNG.get("LoginDialog.bus.label"));
            labelBus.setFont(FONT_LABEL);
            configPanel.add((Component)labelBus, new GBC(0, 1).gridwidth(2).horizontal().insets(6, 6, 3, 6));
            this.comboBus = new JComboBox(busVector);
            this.comboBus.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LoginDialog.this.updateHostPort();
                    BusAddress selectedBus = (BusAddress)LoginDialog.this.comboBus.getSelectedItem();
                    if (selectedBus == BusAddress.UNSPECIFIED_ADDRESS) {
                        LoginDialog.this.fieldHost.requestFocus();
                    } else {
                        LoginDialog.this.fieldUser.requestFocus();
                    }
                }
            });
            configPanel.add((Component)this.comboBus, new GBC(0, 2).gridwidth(2).horizontal().insets(0, 6, 6, 9));
        }
        this.labelHost = new JLabel(LNG.get("LoginDialog.host.label"));
        this.labelHost.setFont(FONT_LABEL);
        configPanel.add((Component)this.labelHost, new GBC(0, 3).west().insets(6, 6, 3, 6));
        this.fieldHost.setToolTipText(LNG.get("LoginDialog.host.help"));
        this.fieldHost.addFocusListener(selectAllTextListener);
        this.fieldHost.getDocument().addDocumentListener(enableLoginListener);
        this.fieldHost.setFocusable(true);
        configPanel.add((Component)this.fieldHost, new GBC(0, 4).horizontal().insets(0, 6, 6, 9));
        this.labelPort = new JLabel(LNG.get("LoginDialog.port.label"));
        this.labelPort.setFont(FONT_LABEL);
        configPanel.add((Component)this.labelPort, new GBC(1, 3).west().insets(6, 0, 3, 6));
        this.fieldPort.setToolTipText(LNG.get("LoginDialog.port.help"));
        this.fieldPort.addFocusListener(selectAllTextListener);
        this.fieldPort.getDocument().addDocumentListener(enableLoginListener);
        this.fieldPort.setFocusable(true);
        configPanel.add((Component)this.fieldPort, new GBC(1, 4).horizontal().insets(0, 0, 6, 6));
        JLabel labelUser = new JLabel(LNG.get("LoginDialog.user.label"));
        labelUser.setFont(FONT_LABEL);
        configPanel.add((Component)labelUser, new GBC(0, 5).west().insets(6, 6, 3, 6));
        this.fieldUser = new JTextField();
        this.fieldUser.setToolTipText(LNG.get("LoginDialog.user.help"));
        this.fieldUser.addFocusListener(selectAllTextListener);
        this.fieldUser.getDocument().addDocumentListener(enableLoginListener);
        this.fieldUser.setFocusable(true);
        configPanel.add((Component)this.fieldUser, new GBC(0, 6).horizontal().insets(0, 6, 6, 9));
        JLabel labelPassword = new JLabel(LNG.get("LoginDialog.password.label"));
        labelPassword.setFont(FONT_LABEL);
        configPanel.add((Component)labelPassword, new GBC(1, 5).west().insets(6, 0, 3, 6));
        this.fieldPassword = new JPasswordField();
        this.fieldPassword.setToolTipText(LNG.get("LoginDialog.password.help"));
        this.fieldPassword.addFocusListener(selectAllTextListener);
        this.fieldPassword.setFocusable(true);
        configPanel.add((Component)this.fieldPassword, new GBC(1, 6).horizontal().insets(0, 0, 6, 6));
        loginPanel.add((Component)configPanel, "Center");
        this.buttonLogin = new JButton(LNG.get("LoginDialog.confirm.button"));
        this.buttonLogin.setToolTipText(LNG.get("LoginDialog.confirm.help"));
        this.buttonLogin.addActionListener(new LoginAction());
        this.buttonLogin.setIcon(ApplicationIcons.ICON_LOGIN_16);
        this.buttonLogin.setEnabled(false);
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.setBorder(new EmptyBorder(9, 3, 3, 3));
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.buttonLogin);
        loginPanel.add((Component)buttonsBox, "South");
        this.setContentPane(loginPanel);
        this.getRootPane().setDefaultButton(this.buttonLogin);
        this.pack();
        this.fillLoginForm();
    }

    private void fillLoginForm() {
        String propertyHost = System.getProperty("host");
        String propertyPort = System.getProperty("port");
        try {
            Integer.parseInt(propertyPort);
        }
        catch (NumberFormatException e) {
            propertyPort = null;
        }
        if (propertyHost == null && propertyPort == null) {
            if (this.comboBus != null) {
                this.updateHostPort();
                this.fieldUser.requestFocus();
            } else {
                this.fieldHost.requestFocus();
            }
        } else {
            if (this.comboBus != null) {
                this.comboBus.setSelectedItem(BusAddress.UNSPECIFIED_ADDRESS);
            }
            this.fieldHost.setText(propertyHost);
            this.fieldPort.setText(propertyPort);
            if (propertyHost == null) {
                this.fieldHost.requestFocus();
            } else if (propertyPort == null) {
                this.fieldPort.requestFocus();
            } else {
                this.fieldUser.requestFocus();
            }
        }
    }

    private void updateHostPort() {
        BusAddress selectedBus = (BusAddress)this.comboBus.getSelectedItem();
        if (selectedBus == BusAddress.UNSPECIFIED_ADDRESS) {
            this.fieldHost.setText("");
            this.fieldPort.setText("");
        } else {
            this.fieldHost.setText(selectedBus.getHost());
            this.fieldPort.setText(Integer.toString(selectedBus.getPort()));
        }
    }

    private class EnableLoginListener
    implements DocumentListener {
        private EnableLoginListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        private void validate() {
            try {
                Integer.parseInt(LoginDialog.this.fieldPort.getText().trim());
            }
            catch (NumberFormatException e) {
                LoginDialog.this.buttonLogin.setEnabled(false);
                return;
            }
            if (LoginDialog.this.fieldHost.getText().trim().length() > 0 && LoginDialog.this.fieldPort.getText().trim().length() > 0 && LoginDialog.this.fieldUser.getText().trim().length() > 0) {
                LoginDialog.this.buttonLogin.setEnabled(true);
            } else {
                LoginDialog.this.buttonLogin.setEnabled(false);
            }
        }
    }

    private class LoginAction
    implements ActionListener {
        private LoginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.LoginByPassword){
                BusExplorerLogin theLogin;

                @Override
                protected void performTask() throws Exception {
                    String host = LoginDialog.this.fieldHost.getText().trim();
                    int port = Integer.parseInt(LoginDialog.this.fieldPort.getText().trim());
                    String entity = LoginDialog.this.fieldUser.getText().trim();
                    String password = new String(LoginDialog.this.fieldPassword.getPassword());
                    this.theLogin = new BusExplorerLogin(LoginDialog.this.admin, entity, host, port);
                    BusExplorerLogin.doLogin(this.theLogin, password);
                }

                @Override
                protected void afterTaskUI() {
                    if (this.getStatus()) {
                        LoginDialog.this.dispose();
                        LoginDialog.this.login = this.theLogin;
                    } else {
                        if (this.theLogin != null) {
                            this.theLogin.logout();
                        }
                        LoginDialog.this.fieldUser.requestFocus();
                    }
                }
            };
            task.execute(LoginDialog.this, LNG.get("LoginDialog.waiting.title"), LNG.get("LoginDialog.waiting.msg"));
        }
    }

    private class SelectAllTextListener
    extends FocusAdapter {
        private SelectAllTextListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            ((JTextField)event.getComponent()).selectAll();
        }
    }
}

