/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.exception;

import busexplorer.exception.BusExplorerHandlingException;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.exception.handling.ExceptionType;
import busexplorer.utils.Utils;
import org.omg.CORBA.NO_PERMISSION;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;

public class BusExplorerExceptionHandler
extends ExceptionHandler<BusExplorerHandlingException> {
    @Override
    protected void handleException(BusExplorerHandlingException exception) {
        Exception theException = exception.getException();
        ExceptionType type = (ExceptionType)((Object)exception.getType());
        ExceptionContext context = exception.getContext();
        block0 : switch (type) {
            case AccessDenied: {
                switch (context) {
                    case LoginByPassword: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "access.denied.password"));
                        break block0;
                    }
                    case LoginByCertificate: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "access.denied.key"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "access.denied"));
                break;
            }
            case ServiceFailure: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "service.failure.core", ((ServiceFailure)theException).message));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "service.failure", ((ServiceFailure)theException).message));
                break;
            }
            case UnauthorizedOperation: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "unauthorized.operation.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "unauthorized.operation"));
                break;
            }
            case EntityAlreadyRegistered: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "entity.already.registered.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "entity.already.registered"));
                break;
            }
            case EntityCategoryAlreadyExists: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "category.already.exists.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "category.already.exists"));
                break;
            }
            case InvalidCertificate: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "invalid.certificate.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "invalid.certificate"));
                break;
            }
            case InterfaceInUse: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "interface.inuse.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "interface.inuse"));
                break;
            }
            case InvalidInterface: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "invalid.interface.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "invalid.interface"));
                break;
            }
            case AuthorizationInUse: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "authorization.inuse.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "authorization.inuse"));
                break;
            }
            case OBJECT_NOT_EXIST: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "not.exist.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "not.exist"));
                break;
            }
            case TRANSIENT: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "transient.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "transient"));
                break;
            }
            case COMM_FAILURE: {
                switch (context) {
                    case BusCore: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "comm.failure.core"));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "comm.failure"));
                break;
            }
            case NO_PERMISSION: {
                NO_PERMISSION noPermission = (NO_PERMISSION)theException;
                switch (context) {
                    case Service: {
                        switch (noPermission.minor) {
                            case 1112888319: {
                                exception.setErrorMessage(Utils.getString(this.getClass(), "no.permission.no.login"));
                                break;
                            }
                            case 1112888068: {
                                exception.setErrorMessage(Utils.getString(this.getClass(), "unknown.bus"));
                                break;
                            }
                            case 1112888067: {
                                exception.setErrorMessage(Utils.getString(this.getClass(), "unverified.login"));
                                break;
                            }
                            case 1112888318: {
                                exception.setErrorMessage(Utils.getString(this.getClass(), "no.permission.invalid.remote"));
                            }
                        }
                        break block0;
                    }
                }
                if (noPermission.minor == 1112888319) {
                    exception.setErrorMessage(Utils.getString(this.getClass(), "no.permission.no.login"));
                    break;
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "no.permission.unspected", noPermission.minor));
                break;
            }
            case InvalidName: {
                exception.setErrorMessage(Utils.getString(this.getClass(), "corba.invalid.name", theException.getMessage()));
                System.exit(1);
                break;
            }
            case IncompatibleBus: {
                switch (context) {
                    case LoginByPassword: 
                    case LoginByCertificate: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "incompatible.bus.login", theException.getMessage()));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "incompatible.bus", theException.getMessage()));
                break;
            }
            case IllegalArgumentException: {
                switch (context) {
                    case LoginByPassword: {
                        exception.setErrorMessage(Utils.getString(this.getClass(), "illegal.argument.login", theException.getMessage()));
                        break block0;
                    }
                }
                exception.setErrorMessage(Utils.getString(this.getClass(), "illegal.argument", theException.getMessage()));
                break;
            }
            default: {
                exception.setErrorMessage(Utils.getString(this.getClass(), "unspecified", theException.getClass().getName(), theException.getMessage()));
            }
        }
    }

    @Override
    protected BusExplorerHandlingException getHandlingException(Exception exception, ExceptionContext context) {
        return new BusExplorerHandlingException(exception, context);
    }
}

