/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.configuration.admins;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.configuration.admins.AdminWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;

public class AdminInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel adminNameLabel;
    private JTextField adminNameField;
    private TablePanelComponent<AdminWrapper> panel;
    private AdminWrapper editingAdministrator = null;

    public AdminInputDialog(Window parentWindow, TablePanelComponent<AdminWrapper> panel, BusAdmin admin) {
        super(parentWindow, LNG.get(AdminInputDialog.class.getSimpleName() + ".title"), admin);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        final ArrayList<String> grantTo = new ArrayList<String>();
        grantTo.add(this.adminNameField.getText());
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                if (AdminInputDialog.this.editingAdministrator == null) {
                    AdminInputDialog.this.admin.grantAdminTo(grantTo);
                } else {
                    ArrayList<String> revokeFrom = new ArrayList<String>();
                    revokeFrom.add(AdminInputDialog.this.editingAdministrator.getAdmin());
                    AdminInputDialog.this.admin.grantAdminTo(grantTo);
                    AdminInputDialog.this.admin.revokeAdminFrom(revokeFrom);
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    AdminInputDialog.this.panel.refresh(null);
                    AdminInputDialog.this.panel.selectElement(new AdminWrapper(AdminInputDialog.this.adminNameField.getText()), true);
                }
            }
        };
        task.execute(this, Utils.getString(this.getClass(), "waiting.title"), Utils.getString(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC baseGBC = new GBC().gridx(0).insets(3).west();
        this.adminNameLabel = new JLabel(LNG.get("AdminInputDialog.adminName.label"));
        panel.add((Component)this.adminNameLabel, new GBC(baseGBC).gridy(0).none());
        this.adminNameField = new JTextField(30);
        panel.add((Component)this.adminNameField, new GBC(baseGBC).gridy(1).horizontal());
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        String administrator = this.adminNameField.getText();
        if (administrator.equals("")) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyID"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(AdminWrapper info) {
        this.editingAdministrator = info;
        this.adminNameField.setText(info.getAdmin());
    }
}

