/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.EntityCategory;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.EntityCategoryDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.RegisteredEntity;

public class EntityInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel entityIDLabel;
    private JTextField entityIDField;
    private JLabel categoryIDLabel;
    private JComboBox categoryIDCombo;
    private JLabel entityNameLabel;
    private JTextField entityNameField;
    private TreeMap<String, EntityCategoryDesc> categories = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TablePanelComponent<EntityWrapper> panel;
    private EntityWrapper editingEntity = null;

    public EntityInputDialog(Window parentWindow, TablePanelComponent<EntityWrapper> panel, BusAdmin admin, List<EntityCategoryDesc> categoryDescList) {
        super(parentWindow, LNG.get(EntityInputDialog.class.getSimpleName() + ".title"), admin);
        this.panel = panel;
        for (EntityCategoryDesc desc : categoryDescList) {
            this.categories.put(desc.id, desc);
        }
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){
            RegisteredEntity entity;

            @Override
            protected void performTask() throws Exception {
                if (EntityInputDialog.this.editingEntity == null) {
                    EntityCategory category = ((EntityInputDialog)EntityInputDialog.this).getCategory().ref;
                    this.entity = category.registerEntity(EntityInputDialog.this.getEntityId(), EntityInputDialog.this.getEntityName());
                } else {
                    this.entity = ((EntityInputDialog)EntityInputDialog.this).editingEntity.getDescriptor().ref;
                    this.entity.setName(EntityInputDialog.this.getEntityName());
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    EntityInputDialog.this.panel.refresh(null);
                    EntityInputDialog.this.panel.selectElement(new EntityWrapper(this.entity.describe()), true);
                }
            }
        };
        task.execute(this, Utils.getString(this.getClass(), "waiting.title"), Utils.getString(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC baseGBC = new GBC().gridx(0).insets(5).west();
        this.categoryIDLabel = new JLabel(Utils.getString(this.getClass(), "categoryID.label"));
        panel.add((Component)this.categoryIDLabel, new GBC(baseGBC).gridy(0).none());
        this.categoryIDCombo = new JComboBox<String>(this.categories.keySet().toArray(new String[this.categories.size()]));
        panel.add((Component)this.categoryIDCombo, new GBC(baseGBC).gridy(1).horizontal());
        this.entityIDLabel = new JLabel(Utils.getString(this.getClass(), "entityID.label"));
        panel.add((Component)this.entityIDLabel, new GBC(baseGBC).gridy(2).none());
        this.entityIDField = new JTextField();
        panel.add((Component)this.entityIDField, new GBC(baseGBC).gridy(3).horizontal());
        this.entityNameLabel = new JLabel(Utils.getString(this.getClass(), "entityName.label"));
        panel.add((Component)this.entityNameLabel, new GBC(baseGBC).gridy(4).none());
        this.entityNameField = new JTextField();
        panel.add((Component)this.entityNameField, new GBC(baseGBC).gridy(5).horizontal());
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        String entityID = this.entityIDField.getText();
        if (entityID.equals("")) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyID"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(EntityWrapper info) {
        this.editingEntity = info;
        this.categoryIDCombo.setSelectedItem(info.getCategory());
        this.categoryIDCombo.setEnabled(false);
        this.entityIDField.setText(info.getId());
        this.entityIDField.setEnabled(false);
        this.entityNameField.setText(info.getName());
    }

    private String getEntityId() {
        return this.entityIDField.getText();
    }

    private String getEntityName() {
        return this.entityNameField.getText();
    }

    private EntityCategoryDesc getCategory() {
        return this.categories.get(this.categoryIDCombo.getSelectedItem());
    }
}

