/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dynany;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.Any;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.dynany.DynAny;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequenceHelper;
import org.slf4j.Logger;

public final class DynSequence
extends DynAny
implements org.omg.DynamicAny.DynSequence {
    private final List<org.omg.CORBA.Any> members = new ArrayList<org.omg.CORBA.Any>();
    private int length;
    private org.omg.CORBA.TypeCode elementType;

    DynSequence(DynAnyFactory dynFactory, org.omg.CORBA.TypeCode type, ORB orb, Logger logger) throws TypeMismatch {
        super(dynFactory, orb, logger);
        org.omg.CORBA.TypeCode _type = TypeCode.originalType(type);
        if (_type.kind() != TCKind.tk_sequence) {
            throw new TypeMismatch();
        }
        try {
            this.typeCode = _type;
            this.elementType = TypeCode.originalType(this.type().content_type());
            this.limit = this.typeCode.length();
            this.length = 0;
        }
        catch (BadKind e) {
            throw this.unexpectedException(e);
        }
        if (this.elementType == null) {
            throw new INTERNAL("DynSequence.set_length, elementType null");
        }
    }

    @Override
    public void from_any(org.omg.CORBA.Any value) throws InvalidValue, TypeMismatch {
        this.from_any_internal(false, value);
    }

    @Override
    void from_any_internal(boolean useCurrentRepresentation, org.omg.CORBA.Any value) throws InvalidValue, TypeMismatch {
        this.checkDestroyed();
        if (!this.type().equivalent(value.type())) {
            throw new TypeMismatch();
        }
        try {
            super.from_any_internal(useCurrentRepresentation, value);
            this.limit = this.type().length();
            InputStream is = value.create_input_stream();
            this.length = is.read_long();
            if (this.length > 0) {
                this.pos = 0;
            }
            if (this.limit != 0 && this.length > this.limit) {
                throw new InvalidValue();
            }
            this.members.clear();
            this.elementType = TypeCode.originalType(this.type().content_type());
            for (int i = 0; i < this.length; ++i) {
                Any any = (Any)this.orb.create_any();
                any.read_value(is, this.elementType);
                this.members.add(any);
            }
        }
        catch (BadKind e) {
            throw this.unexpectedException(e);
        }
        if (this.elementType == null) {
            throw new INTERNAL("DynSequence.set_length, elementType null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.omg.CORBA.Any to_any() {
        this.checkDestroyed();
        org.omg.CORBA.Any out_any = this.orb.create_any();
        out_any.type(this.type());
        CDROutputStream out = new CDROutputStream(this.orb);
        try {
            out.write_long(this.length);
            for (int i = 0; i < this.length; ++i) {
                out.write_value(this.elementType, ((Any)this.members.get(i)).create_input_stream());
            }
            CDRInputStream in = new CDRInputStream(this.orb, out.getBufferCopy());
            try {
                out_any.read_value(in, this.type());
                org.omg.CORBA.Any any = out_any;
                in.close();
                return any;
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
        }
        finally {
            out.close();
        }
    }

    @Override
    public boolean equal(org.omg.DynamicAny.DynAny dyn_any) {
        this.checkDestroyed();
        if (!this.type().equal(dyn_any.type())) {
            return false;
        }
        org.omg.DynamicAny.DynSequence other = DynSequenceHelper.narrow(dyn_any);
        if (other.get_length() != this.get_length()) {
            return false;
        }
        org.omg.CORBA.Any[] elements = this.get_elements();
        org.omg.CORBA.Any[] other_elements = other.get_elements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].equal(other_elements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int get_length() {
        this.checkDestroyed();
        return this.length;
    }

    @Override
    public void set_length(int len) throws InvalidValue {
        this.checkDestroyed();
        if (this.limit > 0 && len > this.limit) {
            throw new InvalidValue();
        }
        if (this.elementType == null) {
            throw new INTERNAL("DynSequence.set_length, elementType null");
        }
        if (len == 0) {
            this.members.clear();
            this.pos = -1;
        } else if (len > this.length) {
            try {
                for (int i = this.length; i < len; ++i) {
                    this.members.add(this.dynFactory.create_dyn_any_from_type_code(this.elementType).to_any());
                }
            }
            catch (InconsistentTypeCode e) {
                throw this.unexpectedException(e);
            }
            if (this.pos == -1) {
                this.pos = len - this.length - 1;
            }
        } else if (len < this.length) {
            int toremove = this.length - len;
            for (int x = 0; x < toremove; ++x) {
                int index = this.length - 1 - x;
                this.members.remove(index);
            }
            if (this.pos > len) {
                this.pos = -1;
            }
        }
        this.length = len;
    }

    @Override
    public org.omg.CORBA.Any[] get_elements() {
        this.checkDestroyed();
        org.omg.CORBA.Any[] result = new Any[this.members.size()];
        int i = this.members.size();
        while (i-- > 0) {
            result[i] = (Any)this.members.get(i);
        }
        return result;
    }

    @Override
    public void set_elements(org.omg.CORBA.Any[] value) throws TypeMismatch, InvalidValue {
        this.checkDestroyed();
        if (this.limit > 0 && value.length > this.limit) {
            throw new InvalidValue();
        }
        int i = value.length;
        while (i-- > 0) {
            org.omg.CORBA.TypeCode tc = TypeCode.originalType(value[i].type());
            if (tc.kind() == this.elementType.kind()) continue;
            throw new TypeMismatch();
        }
        this.length = value.length;
        this.members.clear();
        for (i = 0; i < this.length; ++i) {
            this.members.add(value[i]);
        }
        this.pos = this.length > 0 ? 0 : -1;
    }

    @Override
    public org.omg.DynamicAny.DynAny[] get_elements_as_dyn_any() {
        this.checkDestroyed();
        org.omg.DynamicAny.DynAny[] result = new org.omg.DynamicAny.DynAny[this.members.size()];
        try {
            int i = this.members.size();
            while (i-- > 0) {
                result[i] = this.dynFactory.create_dyn_any((Any)this.members.get(i));
            }
            return result;
        }
        catch (InconsistentTypeCode e) {
            throw this.unexpectedException(e);
        }
    }

    @Override
    public void set_elements_as_dyn_any(org.omg.DynamicAny.DynAny[] value) throws TypeMismatch, InvalidValue {
        this.checkDestroyed();
        org.omg.CORBA.Any[] any_seq = new org.omg.CORBA.Any[value.length];
        int i = value.length;
        while (i-- > 0) {
            any_seq[i] = value[i].to_any();
        }
        this.set_elements(any_seq);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.members.clear();
        this.elementType = null;
    }

    @Override
    protected org.omg.CORBA.Any getRepresentation() {
        return (Any)this.members.get(this.pos);
    }

    @Override
    public boolean next() {
        this.checkDestroyed();
        if (this.pos < this.length - 1) {
            ++this.pos;
            return true;
        }
        this.pos = -1;
        return false;
    }

    @Override
    public boolean seek(int index) {
        this.checkDestroyed();
        if (index < 0) {
            this.pos = -1;
            return false;
        }
        if (index < this.length) {
            this.pos = index;
            return true;
        }
        this.pos = -1;
        return false;
    }

    @Override
    public org.omg.DynamicAny.DynAny current_component() {
        this.checkDestroyed();
        if (this.pos == -1) {
            return null;
        }
        try {
            org.omg.DynamicAny.DynAny result = this.dynFactory.create_dyn_any_from_type_code(this.members.get(this.pos).type());
            ((DynAny)result).from_any_internal(true, this.members.get(this.pos));
            return result;
        }
        catch (InvalidValue iv) {
            this.logger.error("unable to create DynAny", iv);
            throw this.unexpectedException(iv);
        }
        catch (TypeMismatch itc) {
            this.logger.error("unable to create DynAny", itc);
            throw this.unexpectedException(itc);
        }
        catch (InconsistentTypeCode e) {
            this.logger.error("unable to create DynAny", e);
            throw this.unexpectedException(e);
        }
    }

    @Override
    public int component_count() {
        this.checkDestroyed();
        return this.get_length();
    }
}

