/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CodeSet;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.ETF.Profile;
import org.slf4j.Logger;

public class ClientConnection
implements ReplyListener,
ConnectionListener {
    private final GIOPConnection connection;
    private final org.omg.CORBA.ORB orb;
    private final Map<Integer, ReplyPlaceholder> replies;
    private final Map<String, Long> sasContexts;
    private static long last_client_context_id = 0L;
    private int client_count = 0;
    private int id_count = 0;
    private final ClientConnectionManager conn_mg;
    private final boolean client_initiated;
    private boolean listen_point_list_sent = false;
    private boolean gracefulStreamClose;
    private final Profile registeredProfile;
    private final Logger logger;
    private final boolean ignoreComponentInfo;

    public ClientConnection(GIOPConnection connection, org.omg.CORBA.ORB orb, ClientConnectionManager conn_mg, Profile registeredProfile, boolean client_initiated) {
        this.connection = connection;
        this.orb = orb;
        this.conn_mg = conn_mg;
        this.registeredProfile = registeredProfile;
        this.client_initiated = client_initiated;
        Configuration configuration = ((ORB)orb).getConfiguration();
        this.logger = configuration.getLogger("org.jacorb.giop.conn");
        boolean bl = this.ignoreComponentInfo = !configuration.getAttributeAsBoolean("jacorb.codeset", true);
        if (!client_initiated) {
            this.id_count = 1;
        }
        connection.setReplyListener(this);
        connection.setConnectionListener(this);
        this.replies = new HashMap<Integer, ReplyPlaceholder>();
        this.sasContexts = new HashMap<String, Long>();
    }

    public final GIOPConnection getGIOPConnection() {
        return this.connection;
    }

    public Profile getRegisteredProfile() {
        return this.registeredProfile;
    }

    public void setCodeSet(ParsedIOR pior) {
        if (this.isTCSNegotiated()) {
            return;
        }
        if (pior.getEffectiveProfile().version().minor == 0) {
            this.connection.markTCSNegotiated();
            return;
        }
        CodeSetComponentInfo info = pior.getCodeSetComponentInfo();
        if (info != null && !this.ignoreComponentInfo) {
            this.connection.markTCSNegotiated();
            CodeSet c1 = CodeSet.getNegotiatedCodeSet((ORB)this.orb, info, false);
            CodeSet c2 = CodeSet.getNegotiatedCodeSet((ORB)this.orb, info, true);
            this.connection.setCodeSets(c1, c2);
            this.logger.info("Negotiated char codeset of " + c1 + " and wchar of " + c2);
        } else {
            this.logger.debug("No CodeSetComponentInfo in IOR. Will use default CodeSets");
            this.connection.markTCSNegotiated();
        }
    }

    public boolean isTCSNegotiated() {
        return this.connection.isTCSNegotiated();
    }

    public CodeSet getTCS() {
        return this.connection.getTCS();
    }

    public CodeSet getTCSW() {
        return this.connection.getTCSW();
    }

    public synchronized int getId() {
        int result = this.id_count;
        this.id_count += 2;
        return result;
    }

    public synchronized void incClients() {
        ++this.client_count;
    }

    public synchronized boolean decClients() {
        boolean result = false;
        --this.client_count;
        if (this.client_count == 0) {
            result = true;
        }
        return result;
    }

    public int numClients() {
        return this.client_count;
    }

    public boolean isClientInitiated() {
        return this.client_initiated;
    }

    public synchronized boolean isListenPointListSent() {
        boolean rtn = this.listen_point_list_sent;
        this.listen_point_list_sent = true;
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(MessageOutputStream outputStream, ReplyPlaceholder placeholder, int request_id, boolean response_expected) {
        Integer key = request_id;
        Map<Integer, ReplyPlaceholder> map = this.replies;
        synchronized (map) {
            this.replies.put(key, placeholder);
        }
        try {
            this.sendRequest(outputStream, response_expected);
        }
        catch (SystemException e) {
            Map<Integer, ReplyPlaceholder> map2 = this.replies;
            synchronized (map2) {
                this.replies.remove(key);
            }
            throw e;
        }
    }

    public void sendRequest(MessageOutputStream outputStream, boolean response_expected) {
        try {
            this.connection.sendRequest(outputStream, response_expected);
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IOException", e);
            }
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void close() {
        this.connection.close();
    }

    public boolean isClosed() {
        return this.connection.do_close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyReceived(byte[] reply, GIOPConnection connection) {
        connection.decPendingMessages();
        Integer key = Messages.getRequestId(reply);
        ReplyPlaceholder placeholder = null;
        Map<Integer, ReplyPlaceholder> map = this.replies;
        synchronized (map) {
            placeholder = this.replies.remove(key);
        }
        if (placeholder != null) {
            ReplyInputStream ris = new ReplyInputStream(this.orb, reply);
            ris.setCodeSet(this.getTCS(), this.getTCSW());
            placeholder.replyReceived(ris);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received reply for unknown request id: " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateReplyReceived(byte[] reply, GIOPConnection connection) {
        connection.decPendingMessages();
        Integer key = Messages.getRequestId(reply);
        ReplyPlaceholder placeholder = null;
        Map<Integer, ReplyPlaceholder> map = this.replies;
        synchronized (map) {
            placeholder = this.replies.remove(key);
        }
        if (placeholder != null) {
            placeholder.replyReceived(new LocateReplyInputStream(this.orb, reply));
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received reply for unknown request id: " + key);
        }
    }

    @Override
    public void closeConnectionReceived(byte[] close_conn, GIOPConnection connection) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Received CloseConnection on " + connection.toString());
        }
        if (this.client_initiated) {
            this.gracefulStreamClose = true;
            ((ClientGIOPConnection)connection).closeAllowReopen();
            this.streamClosed();
        }
    }

    @Override
    public void connectionClosed() {
        if (!this.client_initiated) {
            this.conn_mg.removeConnection(this);
        }
        this.streamClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamClosed() {
        Map<Integer, ReplyPlaceholder> map = this.replies;
        synchronized (map) {
            if (this.replies.size() > 0) {
                if (this.gracefulStreamClose) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Stream closed. Will remarshal " + this.replies.size() + " messages");
                    }
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Abnormal connection termination. Lost " + this.replies.size() + " outstanding replie(s)!");
                }
                Iterator<ReplyPlaceholder> entries = this.replies.values().iterator();
                while (entries.hasNext()) {
                    ReplyPlaceholder placeholder = entries.next();
                    if (this.gracefulStreamClose) {
                        placeholder.retry();
                    } else {
                        placeholder.cancel();
                    }
                    entries.remove();
                }
            }
        }
        this.gracefulStreamClose = false;
    }

    public Profile get_server_profile() {
        return this.connection.getTransport().get_server_profile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cacheSASContext(byte[] client_authentication_token) {
        long client_context_id = 0L;
        String key = new String(client_authentication_token);
        Map<String, Long> map = this.sasContexts;
        synchronized (map) {
            if (!this.sasContexts.containsKey(key)) {
                client_context_id = ++last_client_context_id;
                this.sasContexts.put(key, client_context_id);
                client_context_id = -client_context_id;
            } else {
                client_context_id = this.sasContexts.get(key);
            }
        }
        return client_context_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long purgeSASContext(long client_context_id) {
        Map<String, Long> map = this.sasContexts;
        synchronized (map) {
            Iterator<String> entries = this.sasContexts.keySet().iterator();
            while (entries.hasNext()) {
                String key = entries.next();
                if (this.sasContexts.get(key) != client_context_id) continue;
                entries.remove();
                break;
            }
        }
        return client_context_id;
    }
}

