/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.miop.MIOPConnection;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.miop.MulticastUtil;
import org.omg.ETF.Profile;
import org.omg.MIOP.PacketHeader_1_0;
import org.omg.MIOP.PacketHeader_1_0Helper;

public class ClientMIOPConnection
extends MIOPConnection
implements Configurable {
    private static short nextMessage = 0;
    private MulticastSocket socket;
    private DatagramPacket packet;
    private short packetDataMaxSize;

    @Override
    public void connect(Profile profile, long timeout) {
        if (this.is_connected()) {
            this.close();
        }
        this.profile = (MIOPProfile)profile;
        try {
            this.socket = new MulticastSocket();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while creating and setting multicast socket " + profile);
        }
    }

    @Override
    public boolean is_connected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public void flush() {
        PacketHeader_1_0 header;
        int i;
        super.flush();
        byte[] data = ((ByteArrayOutputStream)this.out_stream).toByteArray();
        ((ByteArrayOutputStream)this.out_stream).reset();
        int length = data.length;
        int offset = 0;
        short lastPacketSize = (short)(length % this.packetDataMaxSize);
        int numberOfFullPackets = length / this.packetDataMaxSize;
        int numberOfPackets = numberOfFullPackets + (lastPacketSize > 0 ? 1 : 0);
        byte[] messageId = this.generateNewId();
        if (lastPacketSize == 0) {
            --numberOfFullPackets;
            lastPacketSize = this.packetDataMaxSize;
        }
        for (i = 0; i < numberOfFullPackets; ++i) {
            header = new PacketHeader_1_0(MulticastUtil.MAGIC, 16, 0, this.packetDataMaxSize, i, numberOfPackets, messageId);
            this.sendMIOPPacket(header, data, offset + i * this.packetDataMaxSize, this.packetDataMaxSize);
        }
        header = new PacketHeader_1_0(MulticastUtil.MAGIC, 16, 2, lastPacketSize, i, numberOfPackets, messageId);
        this.sendMIOPPacket(header, data, offset + i * this.packetDataMaxSize, lastPacketSize);
    }

    private void sendMIOPPacket(PacketHeader_1_0 header, byte[] data, int offset, int length) {
        CDROutputStream os = new CDROutputStream(this.orb);
        PacketHeader_1_0Helper.write(os, header);
        os.check(length, 8);
        os.write_octet_array(data, offset, length);
        try {
            byte[] buffer = os.getBufferCopy();
            if (this.packet == null) {
                this.packet = new DatagramPacket(buffer, 0, buffer.length, ((MIOPProfile)this.profile).getGroupInetAddress(), ((MIOPProfile)this.profile).getUIPMCProfile().the_port);
            } else {
                this.packet.setData(buffer, 0, buffer.length);
            }
            this.socket.send(this.packet);
        }
        catch (IOException se) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transport to " + this.connection_info + ": stream closed " + se.getMessage());
            }
            throw this.to_COMM_FAILURE(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateNewId() {
        byte[] id = new byte[12];
        byte[] serverId = this.orb.getServerId();
        System.arraycopy(serverId, 0, id, 0, serverId.length);
        Class<ClientMIOPConnection> clazz = ClientMIOPConnection.class;
        synchronized (ClientMIOPConnection.class) {
            id[10] = (byte)(nextMessage >> 8 & 0xFF);
            id[11] = (byte)(nextMessage & 0xFF);
            nextMessage = (short)(nextMessage + 1);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    @Override
    protected int getTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException se) {
            throw this.to_COMM_FAILURE(se);
        }
    }

    @Override
    protected void setTimeout(int timeout) {
        block4: {
            if (this.socket != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Socket timeout set to " + timeout + " ms");
                    }
                    this.socket.setSoTimeout(timeout);
                }
                catch (SocketException se) {
                    if (!this.logger.isInfoEnabled()) break block4;
                    this.logger.info("SocketException", se);
                }
            }
        }
    }

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        int packetMax = config.getAttributeAsInteger("jacorb.miop.packet_max_size", 1500);
        this.packetDataMaxSize = (short)(packetMax - 60);
    }
}

