/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.properties;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.properties.PropertyException;

public class PropertiesUtils {
    private static Pattern PROP_BACKREFERENCE_REGEX = Pattern.compile("\\[%([^%]+?)%\\]");

    public static void loadProperties(Properties props, InputStream inputStream) throws IOException, PropertyException {
        props.load(inputStream);
        PropertiesUtils.fixBackReferences(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties props, String path) throws IOException, PropertyException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            PropertiesUtils.loadProperties(props, inputStream);
        }
        catch (Throwable throwable) {
            FileUtils.close(inputStream);
            throw throwable;
        }
        FileUtils.close(inputStream);
    }

    public static Properties loadProperties(String path) throws IOException, PropertyException {
        Properties props = new Properties();
        PropertiesUtils.loadProperties(props, path);
        return props;
    }

    public static void fixBackReferences(Properties props) throws PropertyException {
        Set<Map.Entry<Object, Object>> propsEntries = props.entrySet();
        for (Map.Entry<Object, Object> entry : propsEntries) {
            String value = ((String)entry.getValue()).trim();
            String realValue = PropertiesUtils.getRealValue(props, value);
            if (realValue.equals(value)) continue;
            entry.setValue(realValue);
        }
        Set<Object> keys = props.keySet();
        Iterator<Object> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.charAt(0) != '_' || !key.endsWith("_")) continue;
            iterator.remove();
        }
    }

    private static String getRealValue(Properties props, String value) throws PropertyException {
        return PropertiesUtils.doGetRealValue(props, value, new HashSet<String>());
    }

    private static String doGetRealValue(Properties props, String value, Set<String> pendingRefs) throws PropertyException {
        Matcher m = PROP_BACKREFERENCE_REGEX.matcher(value);
        if (m.find()) {
            StringBuffer realValue = new StringBuffer();
            do {
                String propRefName;
                if (!pendingRefs.add(propRefName = m.group(1))) {
                    throw new PropertyException("loop na defini\u00e7\u00e3o da vari\u00e1vel " + propRefName);
                }
                String v = props.getProperty(propRefName).trim();
                if (v == null) {
                    throw new PropertyException("backreference inv\u00e1lido: " + value);
                }
                m.appendReplacement(realValue, PropertiesUtils.doGetRealValue(props, v, pendingRefs));
            } while (m.find());
            m.appendTail(realValue);
            return realValue.toString().trim();
        }
        pendingRefs.clear();
        return value;
    }

    public static String getValue(Properties props, String key) throws PropertyException {
        String value = props.getProperty(key);
        if (value == null) {
            throw new PropertyException("propriedade " + key + " n\u00e3o foi definida");
        }
        return value.trim();
    }

    public static int getIntValue(Properties props, String key) throws PropertyException {
        try {
            return Integer.valueOf(PropertiesUtils.getValue(props, key));
        }
        catch (NumberFormatException e) {
            throw new PropertyException(key + " n\u00e3o \u00e9 um inteiro");
        }
    }

    public static long getLongValue(Properties props, String key) throws PropertyException {
        try {
            return Long.valueOf(PropertiesUtils.getValue(props, key));
        }
        catch (NumberFormatException e) {
            throw new PropertyException(key + " n\u00e3o \u00e9 um long");
        }
    }

    public static double getDoubleValue(Properties props, String key) throws PropertyException {
        try {
            return Double.valueOf(PropertiesUtils.getValue(props, key));
        }
        catch (NumberFormatException e) {
            throw new PropertyException(key + " n\u00e3o \u00e9 um double");
        }
    }

    public static float getFloatValue(Properties props, String key) throws PropertyException {
        try {
            return Float.valueOf(PropertiesUtils.getValue(props, key)).floatValue();
        }
        catch (NumberFormatException e) {
            throw new PropertyException(key + " n\u00e3o \u00e9 um float");
        }
    }

    public static boolean getBoolenValue(Properties props, String key) throws PropertyException {
        return PropertiesUtils.getBoolenValue(props, key, false);
    }

    public static boolean getBoolenValue(Properties props, String key, boolean strict) throws PropertyException {
        String value = PropertiesUtils.getValue(props, key);
        if (strict && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            throw new PropertyException(key + " n\u00e3o \u00e9 um booleano");
        }
        return Boolean.valueOf(value);
    }

    public static List<String> getValuesList(Properties props, String keyPrefix) {
        String value;
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while ((value = props.getProperty(keyPrefix + '.' + i)) != null) {
            list.add(value);
            ++i;
        }
        return list;
    }
}

