/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableReportItem;
import tecgraf.javautils.gui.print.TextTool;

public class PrintableText
implements PrintableReportItem {
    public static final String ALIGN_CENTER = "center";
    private String title;
    private Font titleFont;
    private String text;
    private Font textFont;
    private float height;
    private int currentPage;
    private boolean printing;
    private boolean simulating;
    private String alignment;
    protected TextTool textTool;
    protected Rectangle2D rect;
    protected Point2D pt;
    private int textPos;
    private int oldTextPos;
    private float leftInset;
    private boolean changeFont;
    private float width;

    public PrintableText(String text, Font textFont) {
        this(null, null, text, textFont, true);
    }

    public PrintableText(String text, Font textFont, boolean changeFont) {
        this(null, null, text, textFont, changeFont);
    }

    public PrintableText(String title, Font titleFont, String text, Font textFont) {
        this(title, titleFont, text, textFont, true);
    }

    public PrintableText(String title, Font titleFont, String text, Font textFont, boolean changeFont) {
        this.title = title;
        this.titleFont = titleFont;
        this.text = text;
        this.alignment = "left";
        this.textFont = textFont;
        this.changeFont = changeFont;
        this.textTool = new TextTool();
        this.rect = new Rectangle2D.Float();
        this.pt = new Point2D.Float();
        this.leftInset = 0.0f;
    }

    @Override
    public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
        if (!this.simulating) {
            this.init(format);
            this.simulating = true;
        }
        return this.print(g2, format, pageIndex, false);
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
        if (!this.printing) {
            this.init(format);
            this.printing = true;
        }
        return this.print(g2, format, pageIndex, true);
    }

    private void init(PageFormat format) {
        this.currentPage = 0;
        this.textPos = 0;
        this.oldTextPos = 0;
    }

    private boolean print(Graphics2D g2, PageFormat format, int pageIndex, boolean draw) {
        if (pageIndex == this.currentPage) {
            this.textPos = this.oldTextPos;
        }
        this.currentPage = pageIndex;
        this.oldTextPos = this.textPos;
        float titleWidth = 0.0f;
        if (this.title != null) {
            g2.setFont(this.titleFont);
            this.pt.setLocation(format.getImageableX() + (double)this.leftInset, format.getImageableY());
            this.textTool.getBBox(g2, this.title, this.pt, "nw", this.rect);
            if (this.rect.getHeight() > format.getImageableHeight()) {
                return false;
            }
            if (draw) {
                this.textTool.draw(g2, this.title, this.pt, "nw", "left");
            }
            titleWidth = (float)this.rect.getWidth() + 5.0f;
        }
        return this.printText(g2, format, titleWidth, draw);
    }

    private boolean printText(Graphics2D g2, PageFormat pageFormat, float titleWidth, boolean draw) {
        boolean fullPrinted;
        g2.setFont(this.textFont);
        float x = (float)pageFormat.getImageableX() + titleWidth + this.leftInset;
        float y = (float)pageFormat.getImageableY();
        float pageWidth = (float)pageFormat.getImageableWidth() - titleWidth;
        float pageHeight = (float)pageFormat.getImageableHeight();
        this.rect.setRect(x, y, pageWidth, pageHeight);
        this.textPos = draw ? this.textTool.draw(g2, this.text, this.textPos, this.rect, "word", this.alignment) : this.textTool.getBBox(g2, this.text, this.textPos, this.rect, "word", this.alignment);
        this.height = (float)this.rect.getHeight();
        this.width = this.textTool.getMaxWidth();
        boolean bl = fullPrinted = this.textPos >= this.text.length();
        if (fullPrinted) {
            this.textPos = 0;
        }
        return fullPrinted;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public void setLeftInset(float leftInset) {
        this.leftInset = (float)((double)leftInset * 28.346456664);
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
        this.printing = false;
        this.simulating = false;
        if (!this.changeFont) {
            return;
        }
        this.textFont = this.textFont.deriveFont((float)this.textFont.getSize() * configuration.getFontRate());
        if (this.titleFont != null) {
            this.titleFont = this.titleFont.deriveFont((float)this.titleFont.getSize() * configuration.getFontRate());
        }
    }

    @Override
    public float getWidth() {
        return this.width;
    }
}

