/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.SharedAuthSecret;
import tecgraf.openbus.core.CallerChainImpl;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.LegacySupport;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.SharedAuthSecretImpl;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.credential.SignedCallChainHelper;
import tecgraf.openbus.core.v2_0.data_export.ExportedCallChain;
import tecgraf.openbus.core.v2_0.data_export.ExportedCallChainHelper;
import tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuth;
import tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuthHelper;
import tecgraf.openbus.core.v2_0.data_export.ExportedVersion;
import tecgraf.openbus.core.v2_0.data_export.ExportedVersionSeqHelper;
import tecgraf.openbus.core.v2_0.data_export.LegacyExportedCallChain;
import tecgraf.openbus.core.v2_0.data_export.LegacyExportedCallChainHelper;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.exception.InvalidEncodedStream;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.exception.OpenBusInternalException;

final class OpenBusContextImpl
extends LocalObject
implements OpenBusContext {
    private static final Logger logger = Logger.getLogger(OpenBusContextImpl.class.getName());
    private static final int MAGIC_TAG_SIZE = 4;
    private static final byte[] MTAG_CALLCHAIN = new byte[]{66, 85, 83, 1};
    private static final byte[] MTAG_SHAREDAUTH = new byte[]{66, 85, 83, 2};
    private final int CURRENT_CONNECTION_SLOT_ID;
    private final int IGNORE_THREAD_SLOT_ID;
    private int SKIP_INVLOGIN_SLOT_ID;
    private Map<Integer, Connection> connectedById;
    private Connection defaultConn;
    private CallDispatchCallback dispatchCallback;
    private ORB orb;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwlock.writeLock();

    public OpenBusContextImpl(int currentConnectionSlotId, int ignoreThreadSlotId, int invLoginSlotId) {
        this.connectedById = Collections.synchronizedMap(new HashMap());
        this.CURRENT_CONNECTION_SLOT_ID = currentConnectionSlotId;
        this.IGNORE_THREAD_SLOT_ID = ignoreThreadSlotId;
        this.SKIP_INVLOGIN_SLOT_ID = invLoginSlotId;
    }

    @Override
    public ORB orb() {
        return this.orb;
    }

    @Override
    public Connection createConnection(String host, int port) {
        ConnectionImpl conn;
        try {
            conn = new ConnectionImpl(host, port, this, this.orb);
        }
        catch (InvalidPropertyValue e) {
            throw new OpenBusInternalException("BUG: Este erro nunca deveria ocorrer.", e);
        }
        return conn;
    }

    @Override
    public Connection createConnection(String host, int port, Properties props) throws InvalidPropertyValue {
        return new ConnectionImpl(host, port, this, this.orb, props);
    }

    int getCurrentConnectionSlotId() {
        return this.CURRENT_CONNECTION_SLOT_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection setDefaultConnection(Connection conn) {
        Connection old;
        this.writeLock.lock();
        try {
            old = this.defaultConn;
            this.defaultConn = conn;
        }
        finally {
            this.writeLock.unlock();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getDefaultConnection() {
        this.readLock.lock();
        try {
            Connection connection = this.defaultConn;
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Connection setCurrentConnection(Connection conn) {
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            int id;
            Any currentId = current.get_slot(this.CURRENT_CONNECTION_SLOT_ID);
            if (currentId.type().kind().value() != 0) {
                id = currentId.extract_long();
                if (conn == null) {
                    current.set_slot(this.CURRENT_CONNECTION_SLOT_ID, this.orb.create_any());
                    return this.setConnectionById(id, null);
                }
            } else {
                if (conn == null) {
                    return null;
                }
                id = ORBUtils.getMediator(this.orb).getUniqueId();
                Any newId = this.orb.create_any();
                newId.insert_long(id);
                current.set_slot(this.CURRENT_CONNECTION_SLOT_ID, newId);
            }
            return this.setConnectionById(id, conn);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public Connection getCurrentConnection() {
        Any any;
        Connection connection = null;
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            any = current.get_slot(this.CURRENT_CONNECTION_SLOT_ID);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0) {
            int id = any.extract_long();
            connection = this.connectedById.get(id);
        }
        if (connection == null) {
            connection = this.getDefaultConnection();
        }
        return connection;
    }

    @Override
    public CallerChain getCallerChain() {
        Current current = ORBUtils.getPICurrent(this.orb);
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        try {
            Any busany = current.get_slot(mediator.getBusSlotId());
            Any signedany = current.get_slot(mediator.getSignedChainSlotId());
            if (busany.type().kind().value() != 0 && signedany.type().kind().value() != 0) {
                String busId = busany.extract_string();
                SignedCallChain signedChain = SignedCallChainHelper.extract(signedany);
                Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
                CallChain callChain = CallChainHelper.extract(anyChain);
                return new CallerChainImpl(busId, callChain.target, callChain.caller, callChain.originators, signedChain);
            }
            return null;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public void joinChain() throws OpenBusInternalException {
        this.joinChain(null);
    }

    @Override
    public void joinChain(CallerChain chain) {
        CallerChain callerChain = chain = chain != null ? chain : this.getCallerChain();
        if (chain == null) {
            return;
        }
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            SignedCallChain signedChain = ((CallerChainImpl)chain).signedCallChain();
            Any any = this.orb.create_any();
            SignedCallChainHelper.insert(any, signedChain);
            current.set_slot(mediator.getJoinedChainSlotId(), any);
            Any busAny = this.orb.create_any();
            busAny.insert_string(chain.busid());
            current.set_slot(mediator.getJoinedBusSlotId(), busAny);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public void exitChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = this.orb.create_any();
            current.set_slot(mediator.getJoinedChainSlotId(), any);
            current.set_slot(mediator.getJoinedBusSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain getJoinedChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any anybus = current.get_slot(mediator.getJoinedBusSlotId());
            Any anyschain = current.get_slot(mediator.getJoinedChainSlotId());
            if (anybus.type().kind().value() != 0 && anyschain.type().kind().value() != 0) {
                String busId = anybus.extract_string();
                SignedCallChain signedChain = SignedCallChainHelper.extract(anyschain);
                Any chain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
                CallChain callChain = CallChainHelper.extract(chain);
                return new CallerChainImpl(busId, callChain, signedChain);
            }
            return null;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain makeChainFor(String loginId) throws InvalidLogins, ServiceFailure {
        UserException error = null;
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        String busid = conn.busid();
        try {
            CallerChainImpl joined = (CallerChainImpl)this.getJoinedChain();
            if (joined == null || joined.type().equals((Object)CallerChainImpl.ChainType.CHAIN_2_0)) {
                SignedCallChain signedChain = conn.access().signChainFor(loginId);
                ORBMediator mediator = ORBUtils.getMediator(this.orb);
                Any anyChain = mediator.getCodec().decode_value(signedChain.encoded, CallChainHelper.type());
                CallChain callChain = CallChainHelper.extract(anyChain);
                return new CallerChainImpl(busid, callChain, signedChain);
            }
            String target = conn.cache.logins.getLoginEntity(loginId, new OctetSeqHolder());
            LoginInfo[] jorigs = joined.originators();
            String delegate = jorigs != null && jorigs.length > 0 && conn.isLegacyDelegateSetToOriginator() ? jorigs[0].entity : joined.caller().entity;
            LoginInfo[] originators = new LoginInfo[]{new LoginInfo("<unknown>", delegate)};
            CallChain callChain = new CallChain(target, originators, conn.login());
            SignedCallChain signedChain = LegacySupport.buildLegacySignedChain(callChain, this.orb, ORBUtils.getMediator(this.orb).getCodec());
            return new CallerChainImpl(busid, callChain, signedChain);
        }
        catch (FormatMismatch e) {
            error = e;
        }
        catch (TypeMismatch e) {
            error = e;
        }
        catch (InvalidTypeForEncoding e) {
            error = e;
        }
        String errormsg = "Falha inesperada ao criar uma nova cadeia.";
        logger.log(Level.SEVERE, errormsg, error);
        throw new OpenBusInternalException(errormsg, error);
    }

    @Override
    public byte[] encodeChain(CallerChain chain) {
        int idx = 0;
        CallerChainImpl chainImpl = (CallerChainImpl)chain;
        CallerChainImpl.ChainType type = chainImpl.type();
        try {
            byte[] encodedChain;
            ExportedVersion[] exports;
            if (type.equals((Object)CallerChainImpl.ChainType.CHAIN_2_0)) {
                exports = new ExportedVersion[2];
                encodedChain = this.encodeToExported(chainImpl);
                exports[idx] = new ExportedVersion(1112888064, encodedChain);
                ++idx;
            } else {
                exports = new ExportedVersion[1];
            }
            encodedChain = this.encodeToLegacyExported(chainImpl);
            exports[idx] = new ExportedVersion(1234, encodedChain);
            return this.encodeExportedVersions(exports, MTAG_CALLCHAIN);
        }
        catch (InvalidTypeForEncoding e) {
            String message = "Falha inesperada ao codificar uma cadeia para exporta\u00e7\u00e3o";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    private byte[] encodeToExported(CallerChainImpl chain) throws InvalidTypeForEncoding {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        Any anyChain = this.orb.create_any();
        ExportedCallChainHelper.insert(anyChain, new ExportedCallChain(chain.busid(), chain.signedCallChain()));
        return codec.encode_value(anyChain);
    }

    private byte[] encodeToLegacyExported(CallerChain chain) throws InvalidTypeForEncoding {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        Any anyChain = this.orb.create_any();
        String delegate = "";
        LoginInfo[] originators = chain.originators();
        if (originators.length > 0) {
            delegate = originators[0].entity;
        }
        LegacyExportedCallChainHelper.insert(anyChain, new LegacyExportedCallChain(chain.busid(), chain.target(), chain.caller(), delegate));
        return codec.encode_value(anyChain);
    }

    @Override
    public CallerChain decodeChain(byte[] encoded) throws InvalidEncodedStream {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            ExportedVersion[] exports;
            for (ExportedVersion export : exports = this.decodeExportedVersions(encoded, MTAG_CALLCHAIN)) {
                if (export.version == 1112888064) {
                    Any exported = codec.decode_value(export.encoded, ExportedCallChainHelper.type());
                    ExportedCallChain importing = ExportedCallChainHelper.extract(exported);
                    Any anyChain = codec.decode_value(importing.signedChain.encoded, CallChainHelper.type());
                    CallChain chain = CallChainHelper.extract(anyChain);
                    return new CallerChainImpl(importing.bus, chain, importing.signedChain);
                }
                if (export.version != 1234) continue;
                Any exported = codec.decode_value(export.encoded, LegacyExportedCallChainHelper.type());
                LegacyExportedCallChain legacy = LegacyExportedCallChainHelper.extract(exported);
                LoginInfo[] originators = !legacy.delegate.equals("") ? new LoginInfo[]{new LoginInfo("<unknown>", legacy.delegate)} : new LoginInfo[]{};
                CallChain callChain = new CallChain(legacy.target, originators, legacy.caller);
                SignedCallChain signedChain = LegacySupport.buildLegacySignedChain(callChain, this.orb, codec);
                return new CallerChainImpl(legacy.bus, callChain, signedChain);
            }
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar uma cadeia exportada.";
            logger.log(Level.SEVERE, message, e);
            throw new InvalidEncodedStream(message, e);
        }
        throw new InvalidEncodedStream("Vers\u00e3o de cadeia incompat\u00edvel");
    }

    @Override
    public byte[] encodeSharedAuth(SharedAuthSecret secret) {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            Any anySecret = this.orb.create_any();
            SharedAuthSecretImpl secretImpl = (SharedAuthSecretImpl)secret;
            ExportedSharedAuthHelper.insert(anySecret, new ExportedSharedAuth(secretImpl.busid(), secretImpl.attempt(), secretImpl.secret()));
            byte[] encodedSecret = codec.encode_value(anySecret);
            ExportedVersion[] exports = new ExportedVersion[]{new ExportedVersion(1112888064, encodedSecret)};
            return this.encodeExportedVersions(exports, MTAG_SHAREDAUTH);
        }
        catch (InvalidTypeForEncoding e) {
            String message = "Falha inesperada ao codificar um segredo para exporta\u00e7\u00e3o";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public SharedAuthSecret decodeSharedAuth(byte[] encoded) throws InvalidEncodedStream {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            ExportedVersion[] exports;
            for (ExportedVersion export : exports = this.decodeExportedVersions(encoded, MTAG_SHAREDAUTH)) {
                if (export.version != 1112888064) continue;
                Any exported = codec.decode_value(export.encoded, ExportedSharedAuthHelper.type());
                ExportedSharedAuth secret = ExportedSharedAuthHelper.extract(exported);
                return new SharedAuthSecretImpl(secret.bus, secret.attempt, secret.secret, this);
            }
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar um segredo exportado.";
            logger.log(Level.SEVERE, message, e);
            throw new InvalidEncodedStream(message, e);
        }
        throw new InvalidEncodedStream("Vers\u00e3o de segredo incompat\u00edvel");
    }

    private byte[] encodeExportedVersions(ExportedVersion[] exports, byte[] tag) throws InvalidTypeForEncoding {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        Any any = this.orb.create_any();
        ExportedVersionSeqHelper.insert(any, exports);
        byte[] encodedExport = codec.encode_value(any);
        byte[] fullEnconding = new byte[encodedExport.length + 4];
        System.arraycopy(tag, 0, fullEnconding, 0, 4);
        System.arraycopy(encodedExport, 0, fullEnconding, 4, encodedExport.length);
        return fullEnconding;
    }

    private ExportedVersion[] decodeExportedVersions(byte[] encoded, byte[] magictag) throws InvalidEncodedStream, FormatMismatch, TypeMismatch {
        if (encoded.length > 4) {
            byte[] tag = new byte[4];
            byte[] encodedExport = new byte[encoded.length - 4];
            System.arraycopy(encoded, 0, tag, 0, 4);
            System.arraycopy(encoded, 4, encodedExport, 0, encodedExport.length);
            if (Arrays.equals(magictag, tag)) {
                ORBMediator mediator = ORBUtils.getMediator(this.orb);
                Codec codec = mediator.getCodec();
                Any anyexports = codec.decode_value(encodedExport, ExportedVersionSeqHelper.type());
                return ExportedVersionSeqHelper.extract(anyexports);
            }
        }
        String errormsg = "Stream de bytes n\u00e3o corresponde ao tipo de dado esperado.";
        throw new InvalidEncodedStream(errormsg);
    }

    Connection getConnectionById(int id) {
        return this.connectedById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection setConnectionById(int id, Connection conn) {
        Map<Integer, Connection> map = this.connectedById;
        synchronized (map) {
            Connection old = this.connectedById.remove(id);
            if (conn != null) {
                this.connectedById.put(id, conn);
            }
            return old;
        }
    }

    void setORB(ORB orb) {
        this.orb = orb;
    }

    void ignoreThread() {
        Any any = this.orb.create_any();
        any.insert_boolean(true);
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    void unignoreThread() {
        Any any = this.orb.create_any();
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    int getIgnoreThreadSlotId() {
        return this.IGNORE_THREAD_SLOT_ID;
    }

    void ignoreInvLogin() {
        Any any = this.orb.create_any();
        any.insert_boolean(true);
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.SKIP_INVLOGIN_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de callback";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    void unignoreInvLogin() {
        Any any = this.orb.create_any();
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.SKIP_INVLOGIN_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de InvalidLogin";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    int getSkipInvalidLoginSlotId() {
        return this.SKIP_INVLOGIN_SLOT_ID;
    }

    @Override
    public void onCallDispatch(CallDispatchCallback callback) {
        this.dispatchCallback = callback;
    }

    @Override
    public CallDispatchCallback onCallDispatch() {
        return this.dispatchCallback;
    }

    @Override
    public LoginRegistry getLoginRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.logins();
    }

    @Override
    public OfferRegistry getOfferRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.offers();
    }
}

