package busexplorer.exception;

import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionType;
import busexplorer.exception.handling.HandlingException;

/**
 * Wrapper de excees especficos para os demos de colaborao. Esta classe
 * esta associada a enumerao {@link ExceptionType}.
 * 
 * @author Tecgraf
 */
public class BusExplorerHandlingException extends
  HandlingException<ExceptionType> {

  /**
   * Mensagem de erro a ser exibida caso apresente um dilogo como tratamento da
   * exceo.
   */
  private String errorMsg = null;

  /**
   * Construtor.
   * 
   * @param exception a exceo a ser tratada
   * @param context o contexto no qual a exceo ocorreu.
   */
  public BusExplorerHandlingException(Exception exception,
    ExceptionContext context) {
    super(exception, context);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ExceptionType getTypeFromException(Exception exception) {
    return ExceptionType.getType(exception);
  }

  /**
   * Configura a mensagem de erro a ser exibida.
   * 
   * @param message a mensagem de erro a ser associada  exceo.
   */
  public void setErrorMessage(String message) {
    this.errorMsg = message;
  }

  /**
   * Recupera a mensagem de erro a ser exibida.
   * 
   * @return a mensagem de erro construda para a exceo tratada.
   */
  public String getErrorMessage() {
    return this.errorMsg;
  }

}