/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.desktop.dialog.MainDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.JSwitchBox;
import busexplorer.utils.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.EventObject;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.admin.BusAuditFacade;

public class AuditSettingsPanel {
    public static final String ENVIRONMENT = "environment";
    public static final String APPLICATION = "application";
    private BusExplorerTask<Void> retrieveTask;
    private BusExplorerTask<Void> updateTask;
    private JPanel uiElement;

    private static String getString(String key) {
        return Language.get(AuditSettingsPanel.class, key);
    }

    public static AuditSettingsPanel create(Window parentWindow) {
        String labelsConstraint = "grow";
        String fieldsConstraint = "grow";
        Color onColor = Color.orange;
        Color offColor = Color.lightGray;
        JPanel settingsPanel = new JPanel(new MigLayout("wrap 2, fill, insets 5", "[][grow]"));
        String onLabel = Language.get(JSwitchBox.class, "on");
        String offLabel = Language.get(JSwitchBox.class, "off");
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("enabled")), labelsConstraint);
        final JSwitchBox auditEnabled = new JSwitchBox(onLabel, offLabel, onColor, offColor);
        auditEnabled.setSelected(false);
        auditEnabled.setToolTipText(AuditSettingsPanel.getString("enabled.tooltip"));
        settingsPanel.add((Component)auditEnabled, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("url")), "grow, spany 2");
        final JTextArea auditServiceUrl = new JTextArea(3, 35);
        auditServiceUrl.setLineWrap(true);
        auditServiceUrl.setToolTipText(AuditSettingsPanel.getString("url.tooltip"));
        settingsPanel.add((Component)new JScrollPane(auditServiceUrl), "cell 1 1 1 2, grow");
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("proxy")), labelsConstraint);
        final JTextArea httpProxy = new JTextArea(2, 35);
        httpProxy.setLineWrap(true);
        httpProxy.setToolTipText(AuditSettingsPanel.getString("proxy.tooltip"));
        settingsPanel.add((Component)new JScrollPane(httpProxy), fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("credentials")), labelsConstraint);
        final JPasswordField httpCredentials = new JPasswordField();
        httpCredentials.setToolTipText(AuditSettingsPanel.getString("credentials.tooltip"));
        settingsPanel.add((Component)httpCredentials, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("fifolimit")), labelsConstraint);
        final JSpinner fifoLimit = new JSpinner(new SpinnerNumberModel(100000, 1, 10000000, 1));
        fifoLimit.setToolTipText(AuditSettingsPanel.getString("fifolimit.tooltip"));
        settingsPanel.add((Component)fifoLimit, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("fifolength")), labelsConstraint);
        JPanel fifoLengthPanel = new JPanel(new MigLayout("fill, insets 0 3 0 0", "[grow]0[shrink]", "[]"));
        final JLabel fifoLength = new JLabel("0");
        fifoLength.setBorder(BorderFactory.createEtchedBorder(1));
        fifoLength.setHorizontalAlignment(4);
        fifoLength.setToolTipText(AuditSettingsPanel.getString("fifolength.tooltip"));
        final JButton refreshFifoLength = new JButton(ApplicationIcons.ICON_REFRESH_16);
        refreshFifoLength.addActionListener(event -> new BusExplorerTask<Integer>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                if (Application.login().audit.isAuditCapable()) {
                    this.setResult(Application.login().audit.getAuditFIFOLength());
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    fifoLength.setText(((Integer)this.getResult()).toString());
                }
            }
        }.execute(parentWindow, Language.get(MainDialog.class, "conf.apply.waiting.title"), Language.get(MainDialog.class, "conf.apply.waiting.msg")));
        fifoLengthPanel.add((Component)fifoLength, "growx");
        fifoLengthPanel.add(refreshFifoLength);
        settingsPanel.add((Component)fifoLengthPanel, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("discard")), labelsConstraint);
        final JSwitchBox discardOnExit = new JSwitchBox(onLabel, offLabel, onColor, offColor);
        discardOnExit.setSelected(false);
        discardOnExit.setToolTipText(AuditSettingsPanel.getString("discard.tooltip"));
        settingsPanel.add((Component)discardOnExit, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("tasks")), labelsConstraint);
        final JSpinner concurrentTasks = new JSpinner(new SpinnerNumberModel(5, 1, 10000, 1));
        concurrentTasks.setToolTipText(AuditSettingsPanel.getString("tasks.tooltip"));
        settingsPanel.add((Component)concurrentTasks, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString("retrytimeout")), labelsConstraint);
        final JSpinner retryTimeout = new JSpinner(new SpinnerNumberModel(5.0, 1.0, 3600.0, 1.0));
        retryTimeout.setToolTipText(AuditSettingsPanel.getString("retrytimeout.tooltip"));
        settingsPanel.add((Component)retryTimeout, fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString(ENVIRONMENT)), labelsConstraint);
        final JTextArea auditEnvironment = new JTextArea(3, 35);
        auditEnvironment.setLineWrap(true);
        auditEnvironment.setToolTipText(AuditSettingsPanel.getString("environment.tooltip"));
        settingsPanel.add((Component)new JScrollPane(auditEnvironment), fieldsConstraint);
        settingsPanel.add((Component)new JLabel(AuditSettingsPanel.getString(APPLICATION)), labelsConstraint);
        final JTextField auditApplication = new JTextField();
        auditApplication.setToolTipText(AuditSettingsPanel.getString("application.tooltip"));
        settingsPanel.add((Component)auditApplication, fieldsConstraint);
        final JButton cancelButton = new JButton(Language.get(MainDialog.class, "conf.cancel"));
        cancelButton.setToolTipText(Language.get(MainDialog.class, "conf.cancel.tooltip"));
        cancelButton.setIcon(ApplicationIcons.ICON_CANCEL_16);
        cancelButton.setEnabled(false);
        final JButton applyButton = new JButton(Language.get(MainDialog.class, "conf.apply"));
        applyButton.setIcon(ApplicationIcons.ICON_VALIDATE_16);
        applyButton.setEnabled(false);
        applyButton.setToolTipText(Language.get(MainDialog.class, "conf.apply.tooltip"));
        for (Component c : settingsPanel.getComponents()) {
            if (!(c instanceof JSpinner)) continue;
            JSpinner spinner = (JSpinner)c;
            ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setDisabledTextColor(UIManager.getColor("TextField.foreground"));
        }
        settingsPanel.add((Component)cancelButton, "align right, spanx 2, split 2");
        settingsPanel.add(applyButton);
        AuditSettingsPanel result = new AuditSettingsPanel();
        result.uiElement = settingsPanel;
        result.retrieveTask = new BusExplorerTask<Void>(ExceptionContext.BusCore){
            boolean _admin;
            boolean _enabled;
            String _url;
            String _proxy;
            char[] _credentials;
            int _fifolimit;
            int _fifolength;
            boolean _discard;
            int _tasks;
            double _timeout;
            String _environment;
            String _application;
            boolean _capable;
            {
                super(context);
                this._admin = false;
                this._enabled = false;
                this._url = "";
                this._proxy = "";
                this._credentials = new char[0];
                this._fifolimit = 0;
                this._fifolength = 0;
                this._discard = false;
                this._tasks = 0;
                this._timeout = 0.0;
                this._environment = "";
                this._application = "";
                this._capable = false;
            }

            @Override
            protected void doPerformTask() throws Exception {
                BusAuditFacade audit = Application.login().audit;
                this._admin = Application.login().hasAdminRights();
                if (audit.isAuditCapable()) {
                    this._capable = true;
                    this._enabled = audit.getAuditEnabled();
                    this._url = audit.getAuditServiceURL();
                    Arrays.fill(this._credentials, '\u0000');
                    if (this._admin) {
                        byte[] bytes = audit.getAuditHttpAuth();
                        this._credentials = new char[bytes.length];
                        for (int i = 0; i < bytes.length; ++i) {
                            this._credentials[i] = (char)bytes[i];
                        }
                    } else {
                        this._credentials = "".toCharArray();
                    }
                    this._proxy = audit.getAuditHttpProxy();
                    this._fifolimit = audit.getAuditFIFOLimit();
                    this._fifolength = this._enabled ? audit.getAuditFIFOLength() : 0;
                    this._discard = audit.getAuditDiscardOnExit();
                    this._tasks = audit.getAuditPublishingTasks();
                    this._timeout = audit.getAuditPublishingRetryTimeout();
                    Arrays.asList(audit.getAuditEventTemplate()).forEach(nameValueString -> {
                        if (nameValueString.name.equals(AuditSettingsPanel.ENVIRONMENT)) {
                            this._environment = nameValueString.value;
                        }
                        if (nameValueString.name.equals(AuditSettingsPanel.APPLICATION)) {
                            this._application = nameValueString.value;
                        }
                    });
                } else {
                    this._capable = false;
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    if (this._capable) {
                        auditEnabled.setSelected(this._enabled);
                        auditEnabled.setEnabled(this._admin);
                        auditServiceUrl.setText(this._url);
                        auditServiceUrl.setEnabled(this._admin);
                        httpCredentials.setText(String.valueOf(this._credentials));
                        Arrays.fill(this._credentials, '\u0000');
                        httpCredentials.setEnabled(this._admin);
                        httpProxy.setText(this._proxy);
                        httpProxy.setEnabled(this._admin);
                        fifoLimit.setValue(this._fifolimit);
                        fifoLimit.setEnabled(this._admin);
                        fifoLength.setText(Integer.valueOf(this._fifolength).toString());
                        fifoLength.setEnabled(this._admin);
                        discardOnExit.setSelected(this._discard);
                        discardOnExit.setEnabled(this._admin);
                        if (this._enabled) {
                            refreshFifoLength.setEnabled(true);
                            concurrentTasks.setValue(this._tasks);
                            concurrentTasks.setEnabled(false);
                        } else {
                            refreshFifoLength.setEnabled(false);
                            concurrentTasks.setEnabled(this._admin);
                        }
                        retryTimeout.setValue(this._timeout);
                        retryTimeout.setEnabled(this._admin);
                        auditEnvironment.setText(this._environment);
                        auditEnvironment.setEnabled(this._admin);
                        auditApplication.setText(this._application);
                        auditApplication.setEnabled(this._admin);
                        applyButton.setEnabled(false);
                        cancelButton.setEnabled(false);
                    } else {
                        auditEnabled.setSelected(false);
                        auditEnabled.setEnabled(false);
                        auditServiceUrl.setEnabled(false);
                        httpCredentials.setEnabled(false);
                        httpProxy.setEnabled(false);
                        fifoLimit.setEnabled(false);
                        refreshFifoLength.setEnabled(false);
                        fifoLength.setEnabled(false);
                        discardOnExit.setEnabled(false);
                        concurrentTasks.setEnabled(false);
                        retryTimeout.setEnabled(false);
                        auditEnvironment.setEnabled(false);
                        auditApplication.setEnabled(false);
                        applyButton.setEnabled(false);
                        cancelButton.setEnabled(false);
                    }
                }
            }
        };
        result.updateTask = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                BusAuditFacade audit = Application.login().audit;
                boolean hasActivationChanged = audit.getAuditEnabled() != auditEnabled.isSelected();
                audit.setAuditServiceURL(auditServiceUrl.getText().trim());
                audit.setAuditHttpProxy(httpProxy.getText().trim());
                char[] chars = httpCredentials.getPassword();
                byte[] bytes = new byte[chars.length];
                for (int i = 0; i < chars.length; ++i) {
                    bytes[i] = (byte)chars[i];
                }
                audit.setAuditHttpAuth(bytes);
                Arrays.fill(bytes, (byte)0);
                Arrays.fill(chars, '\u0000');
                audit.setAuditFIFOLimit(((SpinnerNumberModel)fifoLimit.getModel()).getNumber().intValue());
                audit.setAuditDiscardOnExit(discardOnExit.isSelected());
                audit.setAuditPublishingRetryTimeout(((SpinnerNumberModel)retryTimeout.getModel()).getNumber().doubleValue());
                audit.setAuditEventTemplate(AuditSettingsPanel.ENVIRONMENT, auditEnvironment.getText().trim());
                audit.setAuditEventTemplate(AuditSettingsPanel.APPLICATION, auditApplication.getText().trim());
                int updatedConcurrentTasks = ((SpinnerNumberModel)concurrentTasks.getModel()).getNumber().intValue();
                if (!audit.getAuditEnabled()) {
                    audit.setAuditPublishingTasks(updatedConcurrentTasks);
                }
                if (hasActivationChanged) {
                    audit.setAuditEnabled(auditEnabled.isSelected());
                    if (!audit.getAuditEnabled()) {
                        audit.setAuditPublishingTasks(updatedConcurrentTasks);
                    }
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    auditServiceUrl.setText(auditServiceUrl.getText().trim());
                    httpProxy.setText(httpProxy.getText().trim());
                    auditEnvironment.setText(auditEnvironment.getText().trim());
                    auditApplication.setText(auditApplication.getText().trim());
                    concurrentTasks.setEnabled(!auditEnabled.isSelected());
                    refreshFifoLength.setEnabled(auditEnabled.isSelected());
                    applyButton.setEnabled(false);
                    cancelButton.setEnabled(false);
                }
            }
        };
        applyButton.addActionListener(actionEvent -> result.getUpdateTask().execute(parentWindow, Language.get(MainDialog.class, "conf.apply.waiting.title"), Language.get(MainDialog.class, "conf.apply.waiting.msg")));
        cancelButton.addActionListener(actionEvent -> result.getRetrieveTask().execute(parentWindow, Language.get(MainDialog.class, "conf.apply.waiting.title"), Language.get(MainDialog.class, "conf.apply.waiting.msg")));
        final Consumer<EventObject> activateButtons = arg -> {
            applyButton.setEnabled(true);
            cancelButton.setEnabled(true);
        };
        DocumentListener listener = new DocumentListener(){

            private void testAndActivate() {
                if (!applyButton.isEnabled()) {
                    activateButtons.accept(null);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.testAndActivate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.testAndActivate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.testAndActivate();
            }
        };
        auditEnabled.addItemListener(activateButtons::accept);
        discardOnExit.addItemListener(activateButtons::accept);
        auditServiceUrl.getDocument().addDocumentListener(listener);
        httpCredentials.getDocument().addDocumentListener(listener);
        httpProxy.getDocument().addDocumentListener(listener);
        auditEnvironment.getDocument().addDocumentListener(listener);
        auditApplication.getDocument().addDocumentListener(listener);
        fifoLimit.addChangeListener(activateButtons::accept);
        concurrentTasks.addChangeListener(activateButtons::accept);
        retryTimeout.addChangeListener(activateButtons::accept);
        return result;
    }

    public BusExplorerTask<Void> getRetrieveTask() {
        return this.retrieveTask;
    }

    public BusExplorerTask<Void> getUpdateTask() {
        return this.updateTask;
    }

    public void activate(boolean shouldActivate) {
        for (Component c : this.panel().getComponents()) {
            if (c instanceof JSpinner) {
                JSpinner spinner = (JSpinner)c;
                spinner.setEnabled(shouldActivate);
                ((JSpinner.NumberEditor)spinner.getEditor()).getTextField().setEditable(shouldActivate);
                continue;
            }
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).setEditable(shouldActivate);
                continue;
            }
            if (!(c instanceof JCheckBox)) continue;
            c.setEnabled(shouldActivate);
        }
    }

    public JPanel panel() {
        return this.uiElement;
    }
}

