/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.integrations;

import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import tecgraf.openbus.services.governance.v1_0.Contract;
import tecgraf.openbus.services.governance.v1_0.Integration;

public class IntegrationWrapper {
    private final List<String> contracts;
    private final Integration remote;
    private final int id;
    private boolean activated;
    private String consumer;
    private String provider;

    public IntegrationWrapper(Integration remote) {
        this.remote = remote;
        this.id = remote.id();
        this.consumer = remote.consumer() == null ? "" : remote.consumer().name();
        this.provider = remote.provider() == null ? "" : remote.provider().name();
        this.contracts = new ArrayList<String>();
        for (Contract contract : remote.contracts()) {
            this.contracts.add(contract.name());
        }
        this.activated = remote.activated();
    }

    public String consumer() {
        return this.consumer;
    }

    public String provider() {
        return this.provider;
    }

    public void consumer(ConsumerWrapper consumer) {
        if (consumer == null) {
            this.consumer = "";
            return;
        }
        if (!consumer.name().equals(this.consumer)) {
            this.consumer = consumer.name();
            this.remote.consumer(consumer.remote());
        }
    }

    public void provider(ProviderWrapper provider) {
        if (provider == null) {
            this.provider = "";
            return;
        }
        if (!provider.name().equals(this.provider)) {
            this.provider = provider.name();
            this.remote.provider(provider.remote());
        }
    }

    public Boolean isActivated() {
        return this.activated;
    }

    public void activate(Boolean b) {
        if (b != this.activated) {
            this.activated = b;
            this.remote.activated(b);
        }
    }

    public List<String> contracts() {
        return Collections.unmodifiableList(this.contracts);
    }

    public void contracts(List<String> updated, boolean shouldAddContractToProvider) {
        ArrayList<String> rollback = new ArrayList<String>();
        for (String contract : updated) {
            if (this.contracts.contains(contract)) continue;
            if (!this.remote.addContract(contract)) {
                if (shouldAddContractToProvider) {
                    if (!this.remote.provider().addContract(contract)) {
                        for (String revert : rollback) {
                            this.remote.provider().removeContract(revert);
                        }
                        throw new IllegalArgumentException(contract);
                    }
                    rollback.add(contract);
                    if (!this.remote.addContract(contract)) {
                        throw new IllegalStateException(contract);
                    }
                } else {
                    throw new IllegalArgumentException(contract);
                }
            }
            this.contracts.add(contract);
        }
        ListIterator<String> iterator = this.contracts.listIterator();
        while (iterator.hasNext()) {
            String contract;
            contract = iterator.next();
            if (updated.contains(contract)) continue;
            this.remote.removeContract(contract);
            iterator.remove();
        }
    }

    public Integration remote() {
        return this.remote;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegrationWrapper)) {
            return false;
        }
        IntegrationWrapper other = (IntegrationWrapper)o;
        return this.id == other.id;
    }

    public static List<IntegrationWrapper> convertToInfo(List<Integration> integrations) {
        ArrayList<IntegrationWrapper> list = new ArrayList<IntegrationWrapper>();
        for (Integration integration : integrations) {
            list.add(new IntegrationWrapper(integration));
        }
        return list;
    }
}

