/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.FactoriesBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.miop.ClientMIOPConnection;
import org.jacorb.orb.miop.MIOPListener;
import org.jacorb.orb.miop.MIOPProfile;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfileHolder;

public class MIOPFactories
extends FactoriesBase
implements Configurable {
    private MIOPListener listener = null;

    @Override
    protected Connection create_connection_internal() {
        return new ClientMIOPConnection();
    }

    @Override
    protected ProtocolAddressBase create_address_internal() {
        return new IIOPAddress();
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    @Override
    public Listener create_listener_internal() {
        if (this.listener == null) {
            this.listener = new MIOPListener();
        }
        return this.listener;
    }

    @Override
    public Profile demarshal_profile(TaggedProfileHolder taggedProfile, TaggedComponentSeqHolder taggedComponentSeq) {
        if (taggedProfile.value.tag != 3) {
            throw new BAD_PARAM("wrong profile for MIOP transport: tag = " + taggedProfile.value.tag);
        }
        MIOPProfile profile = new MIOPProfile(taggedProfile.value.profile_data);
        this.configureResult(profile);
        taggedComponentSeq.value = new TaggedComponent[0];
        return profile;
    }

    @Override
    public int profile_tag() {
        return 3;
    }

    @Override
    public Profile decode_corbaloc(String corbaloc) {
        if (corbaloc.toLowerCase().startsWith("miop")) {
            MIOPProfile profile = new MIOPProfile(corbaloc);
            try {
                profile.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL("ConfigurationException: " + ce.getMessage());
            }
            return profile;
        }
        return null;
    }
}

