/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.japura.gui.CollapsibleRootPanel;
import org.japura.gui.GUIImages;
import org.japura.gui.Gradient;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.event.CollapsiblePanelEvent;
import org.japura.gui.event.CollapsiblePanelListener;

public class CollapsiblePanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static Icon defaultExpandIcon = new ImageIcon(GUIImages.EXPAND_BLACK);
    private static Icon defaultCollapseIcon = new ImageIcon(GUIImages.COLLAPSE_BLACK);
    private static Object defaultTitleBackground = new Gradient(Gradient.TOP_TO_BOTTOM, new Color(160, 190, 255), new Color(240, 240, 255));
    private Icon iconDown;
    private Icon iconUp;
    private JLabel titleIcon;
    private JLabel titleLabel;
    private JLabel titleButton;
    private int titleSeparator = 1;
    private int titleMargin = 3;
    private int iconTitlePadding = 5;
    private int titleButtonsPadding = 5;
    private int buttonsPadding = 5;
    private JLayeredPane layeredPane;
    private JPanel modal;
    private Component component;
    private boolean collapsed;
    private boolean inAction;
    private boolean locked;
    private boolean animationEnabled = true;
    private transient ActionListener collapseListener;
    private transient ActionListener expandListener;
    private Timer collapseTimer;
    private Timer expandTimer;
    private int incremental = 3;
    private int pixels;
    private Object titleBackground;
    private Color separatorColor = new Color(0, 0, 0, 80);
    private JPanel titlePanel;
    private JPanel innerTitlePanel;
    private EventListenerList listeners = new EventListenerList();
    private PopupMenuBuilder<CollapsiblePanel> popupBuilder;
    private JComponent[] extraButtons;
    private Icon icon;
    private int endHeight;
    private int calculatedHeight = -1;
    int weightY = 1;
    private boolean ignoreButtonClick;

    public CollapsiblePanel() {
        this(null, "", null);
    }

    public CollapsiblePanel(String title) {
        this(null, title, null);
    }

    public CollapsiblePanel(Icon icon, String title) {
        this(icon, title, null);
    }

    public CollapsiblePanel(String title, JComponent[] extraButtons) {
        this(null, title, extraButtons);
    }

    public CollapsiblePanel(Icon icon, String title, JComponent[] extraButtons) {
        this.modal = new JPanel();
        this.modal.setOpaque(false);
        this.modal.addMouseListener(new MouseAdapter(){});
        this.titleBackground = defaultTitleBackground;
        this.layeredPane = new JLayeredPane();
        this.layeredPane.add((Component)this.modal, JLayeredPane.MODAL_LAYER);
        super.add(this.layeredPane);
        this.setBorder(BorderFactory.createLineBorder(this.separatorColor));
        this.setLayout(null);
        this.setOpaque(false);
        this.icon = icon;
        this.setTitle(title);
        this.iconDown = defaultExpandIcon;
        this.iconUp = defaultCollapseIcon;
        this.titleButton = new JLabel();
        this.titleButton.setIcon(this.iconUp);
        super.add(this.getTitlePanel());
        this.extraButtons = extraButtons;
        this.buildTitlePanel();
        this.addMouseListener(new MouseAdapter(){

            private boolean check(MouseEvent e) {
                int y = CollapsiblePanel.this.getInnerTitlePanel().getY() - CollapsiblePanel.this.titleMargin;
                int max = CollapsiblePanel.this.getInnerTitlePanel().getY() + CollapsiblePanel.this.getInnerTitlePanel().getHeight() + CollapsiblePanel.this.titleMargin;
                return e.getPoint().y > y && e.getPoint().y < max;
            }

            private void showPopup(MouseEvent e) {
                if (CollapsiblePanel.this.getPopupBuilder() != null) {
                    JPopupMenu pm = CollapsiblePanel.this.getPopupBuilder().buildPopupMenu(CollapsiblePanel.this);
                    pm.show(CollapsiblePanel.this, e.getPoint().x, e.getPoint().y);
                    pm.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            CollapsiblePanel.this.ignoreButtonClick = true;
                        }

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e) {
                        }
                    });
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.check(e) && e.isPopupTrigger()) {
                    CollapsiblePanel.this.ignoreButtonClick = true;
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.check(e)) {
                    if (e.isPopupTrigger()) {
                        this.showPopup(e);
                    } else {
                        if (!CollapsiblePanel.this.ignoreButtonClick) {
                            CollapsiblePanel.this.buttonAction();
                        }
                        CollapsiblePanel.this.ignoreButtonClick = false;
                    }
                }
            }
        });
    }

    public void setPopupBuilder(PopupMenuBuilder<CollapsiblePanel> popupBuilder) {
        this.popupBuilder = popupBuilder;
    }

    public PopupMenuBuilder<CollapsiblePanel> getPopupBuilder() {
        return this.popupBuilder;
    }

    public void removeExtraButtons() {
        this.extraButtons = null;
        this.buildTitlePanel();
    }

    public void setExtraButtons(JComponent[] extraButtons) {
        this.extraButtons = extraButtons;
        this.buildTitlePanel();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = 0;
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getNorthPreferredHeight();
        this.getTitlePanel().setBounds(x, y, width, height);
        if (this.component != null) {
            if (!this.collapsed || this.inAction) {
                Dimension dim = this.component.getPreferredSize();
                x = insets.left;
                y += height + this.titleSeparator;
                height = this.getHeight() - y - insets.bottom;
                this.layeredPane.setBounds(x, y, width, height);
                y = Math.min(this.layeredPane.getHeight() - dim.height, 0);
                if (this.isFillMode()) {
                    this.component.setBounds(0, 0, width, height);
                } else {
                    this.component.setBounds(0, y, width, this.layeredPane.getHeight() - y);
                }
                if (this.inAction) {
                    this.modal.setBounds(0, y, width, this.layeredPane.getHeight() - y);
                } else {
                    this.modal.setBounds(0, 0, 0, 0);
                }
            } else {
                this.layeredPane.setBounds(0, 0, 0, 0);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Insets insets = this.getInsets();
        int y = this.getInnerTitlePanel().getY() - this.titleMargin;
        int height = this.getInnerTitlePanel().getHeight() + 2 * this.titleMargin;
        if (this.hasTitleBackgroundGradient()) {
            GradientPaint gp = null;
            Gradient gradient = (Gradient)this.getTitleBackground();
            Gradient.Direction direction = gradient.getDirection();
            Color firstColor = gradient.getFirstColor();
            Color secondColor = gradient.getSecondColor();
            if (direction.equals((Object)Gradient.Direction.TOP_TO_BOTTOM)) {
                gp = new GradientPaint(0.0f, y, firstColor, 0.0f, y + height, secondColor);
            } else if (direction.equals((Object)Gradient.Direction.BOTTOM_TO_TOP)) {
                gp = new GradientPaint(0.0f, y, secondColor, 0.0f, y + height, firstColor);
            } else if (direction.equals((Object)Gradient.Direction.LEFT_TO_RIGHT)) {
                gp = new GradientPaint(insets.left, 0.0f, firstColor, this.getWidth() - (insets.left + insets.right), 0.0f, secondColor);
            } else if (direction.equals((Object)Gradient.Direction.RIGHT_TO_LEFT)) {
                gp = new GradientPaint(insets.left, 0.0f, secondColor, this.getWidth() - (insets.left + insets.right), 0.0f, firstColor);
            }
            g2d.setPaint(gp);
        } else {
            Color color = (Color)this.getTitleBackground();
            g2d.setColor(color);
        }
        g2d.fillRect(insets.left, y, this.getWidth() - (insets.left + insets.right), height);
        g2d.setColor(this.getSeparatorColor());
        g2d.fillRect(insets.left, y += height, this.getWidth() - (insets.left + insets.right), this.titleSeparator);
    }

    @Override
    protected final void paintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            int y = this.getInnerTitlePanel().getY() - this.getInsets().top - this.titleMargin;
            border.paintBorder(this, g, 0, y, this.getWidth(), this.getHeight() - y);
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.getPreferredSize(this.collapsed);
    }

    protected Dimension getPreferredSize(boolean collapsed) {
        Dimension dim = new Dimension(this.titlePanel.getPreferredSize());
        dim.height = this.getNorthPreferredHeight();
        Dimension cdim = null;
        cdim = this.component != null ? this.component.getPreferredSize() : new Dimension();
        if (!collapsed && this.component != null) {
            dim.height += this.titleSeparator;
            dim.height += cdim.height;
        }
        dim.width = Math.max(dim.width, cdim.width);
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.bottom;
        return dim;
    }

    public void removeIcon() {
        this.icon = null;
        this.buildTitlePanel();
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.buildTitlePanel();
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel();
        }
        return this.titleLabel;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setOpaque(false);
            this.titlePanel.setLayout(new GridBagLayout());
        }
        return this.titlePanel;
    }

    private void buildTitlePanel() {
        this.getTitlePanel().removeAll();
        this.titleIcon = null;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        if (this.icon != null) {
            this.titleIcon = new JLabel(this.icon);
            gbc.insets = new Insets(this.titleMargin, this.titleMargin, this.titleMargin, this.iconTitlePadding);
            this.getTitlePanel().add((Component)this.titleIcon, gbc);
            gbc.insets = new Insets(this.titleMargin, 0, this.titleMargin, this.titleMargin);
        } else {
            gbc.insets = new Insets(this.titleMargin, this.titleMargin, this.titleMargin, this.titleMargin);
        }
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.buildInnerTitlePanel();
        this.getTitlePanel().add((Component)this.getInnerTitlePanel(), gbc);
        this.getTitlePanel().revalidate();
    }

    private void buildInnerTitlePanel() {
        this.getInnerTitlePanel().removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, this.titleButtonsPadding);
        this.getInnerTitlePanel().add((Component)this.getTitleLabel(), gbc);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        if (this.extraButtons != null) {
            for (int i = 0; i < this.extraButtons.length; ++i) {
                gbc.gridx = -1;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 0, this.buttonsPadding);
                this.getInnerTitlePanel().add((Component)this.extraButtons[i], gbc);
            }
        }
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getInnerTitlePanel().add((Component)this.titleButton, gbc);
        this.getInnerTitlePanel().revalidate();
    }

    private JPanel getInnerTitlePanel() {
        if (this.innerTitlePanel == null) {
            this.innerTitlePanel = new JPanel();
            this.innerTitlePanel.setOpaque(false);
            this.innerTitlePanel.setLayout(new GridBagLayout());
        }
        return this.innerTitlePanel;
    }

    private int getNorthPreferredHeight() {
        Insets insets = this.getInsets();
        int innerTitleHeight = this.getInnerTitlePanel().getPreferredSize().height;
        innerTitleHeight += 2 * this.titleMargin;
        int titleIconHeight = 0;
        if (this.titleIcon != null) {
            titleIconHeight = this.titleIcon.getPreferredSize().height;
            titleIconHeight += this.titleMargin + insets.top;
        } else {
            innerTitleHeight += insets.top;
        }
        return Math.max(innerTitleHeight, titleIconHeight);
    }

    public void setSeparatorThickness(int thickness) {
        this.titleSeparator = Math.max(0, thickness);
    }

    public boolean isCollapsed() {
        return this.collapsed && !this.inAction;
    }

    public boolean isCollapsing() {
        return !this.collapsed && this.inAction;
    }

    public boolean isExpanded() {
        return !this.collapsed && !this.inAction;
    }

    public boolean isExpanding() {
        return this.collapsed && this.inAction;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        if (!this.inAction) {
            this.animationEnabled = animationEnabled;
        }
    }

    public void setSpeed(int speed) {
        this.incremental = Math.max(speed, 1);
    }

    public int getSpeed() {
        return this.incremental;
    }

    @Override
    public void remove(Component arg0) {
        if (this.component.equals(arg0)) {
            this.removeView();
        }
    }

    @Override
    public void remove(int arg0) {
    }

    @Override
    public void removeAll() {
        this.removeView();
    }

    private void removeView() {
        if (this.component != null) {
            this.layeredPane.remove(this.component);
            this.component = null;
        }
    }

    private void setView(Component component) {
        this.removeView();
        if (component != null) {
            this.component = component;
            this.layeredPane.add(component, JLayeredPane.DEFAULT_LAYER);
        }
    }

    @Override
    public Component add(Component comp, int index) {
        this.setView(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.setView(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.setView(comp);
    }

    @Override
    public Component add(Component comp) {
        this.setView(comp);
        return comp;
    }

    @Override
    public Component add(String name, Component comp) {
        this.setView(comp);
        return comp;
    }

    private ActionListener getExpandListener() {
        if (this.expandListener == null) {
            this.expandListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CollapsiblePanel.this.calculatedHeight += CollapsiblePanel.this.pixels;
                    CollapsiblePanel.this.pixels += CollapsiblePanel.this.incremental;
                    CollapsiblePanel.this.revalidate();
                    if (CollapsiblePanel.this.calculatedHeight >= CollapsiblePanel.this.endHeight) {
                        CollapsiblePanel.this.changeStatus();
                    }
                }
            };
        }
        return this.expandListener;
    }

    private ActionListener getCollapseListener() {
        if (this.collapseListener == null) {
            this.collapseListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CollapsiblePanel.this.calculatedHeight -= CollapsiblePanel.this.pixels;
                    CollapsiblePanel.this.pixels += CollapsiblePanel.this.incremental;
                    CollapsiblePanel.this.revalidate();
                    if (CollapsiblePanel.this.calculatedHeight <= CollapsiblePanel.this.endHeight) {
                        CollapsiblePanel.this.changeStatus();
                    }
                }
            };
        }
        return this.collapseListener;
    }

    private void changeStatus() {
        CollapsiblePanelListener[] array;
        if (this.collapsed) {
            this.getExpandTimer().stop();
            this.setIconUp();
            this.calculatedHeight = -1;
        } else {
            this.calculatedHeight = this.getCollapsedHeight();
            this.getCollapseTimer().stop();
            this.setIconDown();
        }
        this.revalidate();
        this.collapsed = !this.collapsed;
        this.inAction = false;
        for (CollapsiblePanelListener cpl : array = (CollapsiblePanelListener[])this.listeners.getListeners(CollapsiblePanelListener.class)) {
            if (this.collapsed) {
                cpl.panelCollapsed(new CollapsiblePanelEvent(this));
                continue;
            }
            cpl.panelExpanded(new CollapsiblePanelEvent(this));
        }
    }

    private Timer getCollapseTimer() {
        if (this.collapseTimer == null) {
            this.collapseTimer = new Timer(25, this.getCollapseListener());
        }
        return this.collapseTimer;
    }

    private Timer getExpandTimer() {
        if (this.expandTimer == null) {
            this.expandTimer = new Timer(25, this.getExpandListener());
        }
        return this.expandTimer;
    }

    public boolean isLockEnabled() {
        return this.locked;
    }

    public void setLockEnabled(boolean enabled) {
        this.locked = enabled;
        this.titleButton.setVisible(!enabled);
    }

    public void collapseImmediately() {
        this.collapse(true);
    }

    public void collapse() {
        this.collapse(false);
    }

    private int getCollapsedHeight() {
        Insets insets = this.getInsets();
        return this.getNorthPreferredHeight() + insets.bottom;
    }

    private void collapse(boolean immediately) {
        if (!(this.locked || this.inAction || this.collapsed)) {
            CollapsiblePanelListener[] array;
            this.inAction = true;
            for (CollapsiblePanelListener cpl : array = (CollapsiblePanelListener[])this.listeners.getListeners(CollapsiblePanelListener.class)) {
                cpl.panelWillCollapse(new CollapsiblePanelEvent(this));
            }
            this.pixels = this.incremental;
            if (this.isAnimationEnabled() && !immediately) {
                this.calculatedHeight = this.getSize().height;
                this.endHeight = this.getCollapsedHeight();
                this.getCollapseTimer().start();
            } else {
                this.changeStatus();
            }
        }
    }

    public void expandImmediately() {
        this.expand(true);
    }

    public void expand() {
        this.expand(false);
    }

    private void expand(boolean immediately) {
        if (!this.locked && !this.inAction && this.collapsed) {
            CollapsiblePanelListener[] array;
            this.inAction = true;
            for (CollapsiblePanelListener cpl : array = (CollapsiblePanelListener[])this.listeners.getListeners(CollapsiblePanelListener.class)) {
                cpl.panelWillExpand(new CollapsiblePanelEvent(this));
            }
            this.pixels = this.incremental;
            if (this.isAnimationEnabled() && !immediately) {
                this.calculatedHeight = this.getSize().height;
                if (this.isFillMode()) {
                    this.setEndHeights();
                } else {
                    this.endHeight = this.getPreferredSize((boolean)false).height;
                }
                this.getExpandTimer().start();
            } else {
                this.changeStatus();
            }
        }
    }

    private boolean isCollapsiblePanelRootExists() {
        return SwingUtilities.getAncestorOfClass(CollapsibleRootPanel.class, this) != null;
    }

    private void buttonAction() {
        if (this.isCollapsiblePanelRootExists() && !this.locked && !this.inAction) {
            if (this.collapsed) {
                this.expand();
            } else {
                this.collapse();
            }
        }
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    @Override
    public Font getFont() {
        return this.getTitleLabel().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getTitleLabel().setFont(font);
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.getTitleLabel().setText(title);
    }

    public String getTitle() {
        return this.getTitleLabel().getText();
    }

    public void setTitleForeground(Color color) {
        this.getTitleLabel().setForeground(color);
    }

    public Color getTitleForeground() {
        return this.getTitleLabel().getForeground();
    }

    public void setTitleBackground(Color color) {
        if (color != null) {
            this.titleBackground = color;
        }
    }

    public void setTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            this.titleBackground = gradient;
        }
    }

    public Object getTitleBackground() {
        return this.titleBackground;
    }

    public boolean hasTitleBackgroundGradient() {
        return this.titleBackground instanceof Gradient;
    }

    public int getTitleMargin() {
        return this.titleMargin;
    }

    public void setTitleMargin(int titleMargin) {
        this.titleMargin = Math.max(0, titleMargin);
    }

    private void setIconDown() {
        this.titleButton.setIcon(this.iconDown);
    }

    private void setIconUp() {
        this.titleButton.setIcon(this.iconUp);
    }

    public void setIcons(Icon iconUp, Icon iconDown) {
        if (!this.inAction) {
            this.iconUp = iconUp;
            this.iconDown = iconDown;
            if (this.collapsed) {
                this.setIconDown();
            } else {
                this.setIconUp();
            }
        }
    }

    public void addCollapsiblePanelListener(CollapsiblePanelListener listener) {
        this.listeners.add(CollapsiblePanelListener.class, listener);
    }

    public void removeCollapsiblePanelListener(CollapsiblePanelListener listener) {
        this.listeners.remove(CollapsiblePanelListener.class, listener);
    }

    public boolean isInAction() {
        return this.inAction;
    }

    private void setEndHeights() {
        Container ct = this.getParent();
        if (ct != null && ct instanceof CollapsibleRootPanel) {
            CollapsibleRootPanel crp = (CollapsibleRootPanel)ct;
            crp.adjustEndHeights();
        }
    }

    private boolean isFillMode() {
        CollapsibleRootPanel crp;
        Container ct = this.getParent();
        return ct != null && ct instanceof CollapsibleRootPanel && (crp = (CollapsibleRootPanel)ct).getMode().equals((Object)CollapsibleRootPanel.FILL);
    }

    void setCalculatedHeight(int h) {
        this.calculatedHeight = h;
    }

    int getCalculatedHeight() {
        if (this.calculatedHeight == -1) {
            this.calculatedHeight = this.getPreferredSize().height;
        }
        return this.calculatedHeight;
    }

    void setEndHeight(int endHeight) {
        this.endHeight = endHeight;
    }

    @Override
    public void invalidate() {
        if (!this.inAction) {
            this.calculatedHeight = -1;
        }
        super.invalidate();
    }

    public static void setDefaultExpandIcon(Icon icon) {
        if (icon == null) {
            icon = new ImageIcon(GUIImages.EXPAND_BLACK);
        }
        defaultExpandIcon = icon;
    }

    public static void setDefaultCollapseIcon(Icon icon) {
        if (icon == null) {
            icon = new ImageIcon(GUIImages.COLLAPSE_BLACK);
        }
        defaultCollapseIcon = icon;
    }

    public static void setDefaultBlackIcons() {
        defaultExpandIcon = new ImageIcon(GUIImages.EXPAND_BLACK);
        defaultCollapseIcon = new ImageIcon(GUIImages.COLLAPSE_BLACK);
    }

    public static void setDefaultWhiteIcons() {
        defaultExpandIcon = new ImageIcon(GUIImages.EXPAND_WHITE);
        defaultCollapseIcon = new ImageIcon(GUIImages.COLLAPSE_WHITE);
    }

    public static Object getDefaultTitleBackground() {
        return defaultTitleBackground;
    }

    public static void setDefaultTitleBackground(Color color) {
        if (color != null) {
            defaultTitleBackground = color;
        }
    }

    public static void setDefaultTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            defaultTitleBackground = gradient;
        }
    }
}

