/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.wizard;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.imagepanel.ImagePanel;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.IWizardListener;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepGroup;
import tecgraf.javautils.gui.wizard.Wizard;
import tecgraf.javautils.gui.wizard.WizardException;
import tecgraf.javautils.gui.wizard.utils.changedlisteners.WasChangedActionListener;
import tecgraf.javautils.gui.wizard.utils.panels.LeftImagedPanel;

public final class WizardSample
extends JFrame
implements IWizardListener {
    private Wizard wizard = this.makeWizard();

    private WizardSample() {
        super("Exemplo do Wizard");
        this.setDefaultCloseOperation(3);
        this.getContentPane().add(this.wizard);
        this.pack();
    }

    private static BufferedImage createImage(String imageIconName) {
        BufferedImage buffImg;
        URL res = Wizard.class.getResource(imageIconName);
        if (res == null) {
            return null;
        }
        try {
            buffImg = ImageIO.read(res);
        }
        catch (IOException e) {
            return null;
        }
        return buffImg;
    }

    public static void main(String[] args) {
        LNG.load("javautils_lng", new Locale("pt", "BR"));
        WizardSample frame = new WizardSample();
        frame.setVisible(true);
    }

    private Wizard makeWizard() {
        ArrayList<StepGroup> stepGroupList = new ArrayList<StepGroup>();
        StepGroup stepGroup1 = new StepGroup("Descri\u00e7\u00e3o");
        stepGroup1.add(new StepExample1());
        StepGroup stepGroup2 = new StepGroup("Descri\u00e7\u00e3o 2");
        stepGroup2.add(new StepExample2());
        stepGroupList.add(stepGroup1);
        stepGroupList.add(stepGroup2);
        Wizard wizard = new Wizard(StepExample1.class, stepGroupList, null, null, Wizard.FinishingType.CLOSEABLE, null, false);
        wizard.setHideFinishButtonsWhenDisabled(true);
        wizard.addListener(this);
        return wizard;
    }

    @Override
    public void wasCancelled(Step step) {
    }

    @Override
    public void wasClosed(Step step) {
        this.dispose();
    }

    @Override
    public void wasConfirmed(Step step, Object object) {
    }

    @Override
    public void wasGoneNext(Step step, History history) {
    }

    @Override
    public void wasGonePrevious(Step step, History history) {
    }

    @Override
    public void wasHappenedException(Step step, WizardException exception) {
    }

    private static final class StepExample2
    extends Step {
        private StepExample2() {
        }

        @Override
        protected boolean canCancel() {
            return false;
        }

        @Override
        protected void cancel() throws WizardException {
        }

        @Override
        protected boolean canConfirm() {
            return false;
        }

        @Override
        protected Object confirm(History history) throws WizardException {
            return null;
        }

        @Override
        protected void enter(History history) throws WizardException {
        }

        @Override
        protected void exit(History history) {
        }

        @Override
        protected String getConfirmActionName() {
            return null;
        }

        @Override
        protected String getConfirmActionTooltip() {
            return null;
        }

        @Override
        protected Container getContainer() {
            return new JPanel();
        }

        @Override
        protected String getInstruction() {
            return "Instru\u00e7\u00f5es 2";
        }

        @Override
        protected Class<? extends Step> getNext(History history) {
            return null;
        }

        @Override
        protected String getTitle() {
            return "T\u00edtulo 2";
        }

        @Override
        protected boolean isTranslationCompleted(History history) {
            return false;
        }

        @Override
        protected boolean isReady() {
            return true;
        }

        @Override
        protected void translate(History history, Object data) {
        }

        @Override
        protected boolean canClose() {
            return false;
        }
    }

    private static final class StepExample1
    extends Step {
        private LeftImagedPanel panel;
        private JCheckBox ckBox;

        StepExample1() {
            final BufferedImage stepImage = WizardSample.createImage("WizardSample.png");
            this.ckBox = new JCheckBox("Clique aqui para habilitar o pr\u00f3ximo passo!");
            this.ckBox.addActionListener(new WasChangedActionListener(this));
            this.ckBox.addActionListener(new ActionListener(){
                boolean toggle = false;

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggle = !this.toggle;
                    panel.setLeftImage(this.toggle ? stepImage : null);
                }
            });
            this.panel = new LeftImagedPanel();
            this.panel.setLeftImage(stepImage);
            this.panel.setHorAlign(ImagePanel.HorAlign.CENTER);
            this.panel.setVerAlign(ImagePanel.VerAlign.CENTER);
            this.panel.setBackground(new Color(22, 107, 65));
            JPanel chkPanel = new JPanel();
            chkPanel.add(this.ckBox);
            this.panel.setRightContainer(chkPanel);
            this.setConfirmOperation(Step.ConfirmOperation.GO_NEXT);
        }

        @Override
        protected boolean canCancel() {
            return false;
        }

        @Override
        protected void cancel() throws WizardException {
        }

        @Override
        protected boolean canConfirm() {
            return true;
        }

        @Override
        protected Object confirm(History history) throws WizardException {
            System.out.println("Confirmou...");
            return null;
        }

        @Override
        protected void enter(History history) throws WizardException {
        }

        @Override
        protected void exit(History history) {
        }

        @Override
        protected String getConfirmActionName() {
            return "Concluir";
        }

        @Override
        protected String getConfirmActionTooltip() {
            return "Clique para concluir";
        }

        @Override
        protected Container getContainer() {
            return this.panel;
        }

        @Override
        protected String getInstruction() {
            return "Instru\u00e7\u00f5es";
        }

        @Override
        protected Class<? extends Step> getNext(History history) {
            return StepExample2.class;
        }

        @Override
        protected String getTitle() {
            return "T\u00edtulo";
        }

        @Override
        protected boolean isTranslationCompleted(History history) {
            return false;
        }

        @Override
        protected boolean isReady() {
            return this.ckBox.isSelected();
        }

        @Override
        protected void translate(History history, Object data) {
        }

        @Override
        protected boolean canClose() {
            return true;
        }
    }
}

