package busexplorer.exception.handling;

/**
 * Esta enumerao deveria manter todas as excees que se deseja tratar pelo
 * {@link ExceptionHandler}. Como no  possvel estender um enum, deve-se
 * definir uma nova enumerao. O {@link ExceptionHandler} ir obter esta
 * enumerao atravs da definio de uma {@link HandlingException}.
 * 
 * @author Tecgraf
 */
public enum ExceptionType {
  // Contexto de Login (LoginBy* + BusCore)
  AccessDenied,
  AlreadyLoggedIn,
  UnknownDomain,
  TooManyAttempts,
  // Contexto BusCore
  ServiceFailure,
  UnauthorizedOperation,
  UnauthorizedFacets,
  InvalidService,
  EntityAlreadyRegistered,
  EntityCategoryAlreadyExists,
  InvalidCertificate,
  InterfaceInUse,
  InvalidInterface,
  AuthorizationInUse,
  // Excees CORBA
  InvalidName,
  NO_PERMISSION,
  COMM_FAILURE,
  TRANSIENT,
  OBJECT_NOT_EXIST,
  // Outros
  IncompatibleBus,
  IllegalArgumentException,
  /** Excees no categorizadas */
  Unspecified;

  /**
   * Recupera um {@link ExceptionType} a partir da exceo real.
   * 
   * @param exception a exceo real
   * @return a enumerao que representa a exceo
   */
  public static ExceptionType getType(Exception exception) {
    try {
      Class<? extends Exception> theClass = exception.getClass();
      return ExceptionType.valueOf(theClass.getSimpleName());
    }
    catch (NullPointerException | IllegalArgumentException ex) {
      return ExceptionType.Unspecified;
    }
  }

}
