/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.services.collaboration.easy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import scs.core.IComponent;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.services.collaboration.easy.IEasyCollaboration;
import tecgraf.openbus.services.collaboration.easy.Utils;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationObserver;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationObserverHelper;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationObserverPOA;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationRegistry;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationRegistryHelper;
import tecgraf.openbus.services.collaboration.v1_0.CollaborationSession;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumer;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumerHelper;
import tecgraf.openbus.services.collaboration.v1_0.EventConsumerPOA;
import tecgraf.openbus.services.collaboration.v1_0.SessionDoesNotExist;
import tecgraf.openbus.services.collaboration.v1_0.SessionRegistry;
import tecgraf.openbus.services.collaboration.v1_0.SessionRegistryHelper;

public class EasyCollaboration
implements IEasyCollaboration {
    private OpenBusContext context;
    private SessionRegistry sessions;
    private CollaborationRegistry collabs;
    private CollaborationSession theSession;
    private Consumer servant;
    private SessionObserver observer;
    private EventConsumer consumer;
    private int subsId;
    private int obsId;
    private static Logger logger = Logger.getLogger(EasyCollaboration.class.getName());

    public EasyCollaboration(OpenBusContext context) {
        this.context = context;
    }

    @Override
    public CollaborationSession startCollaboration() throws ServiceFailure {
        logger.info("Starting collaboration");
        SessionRegistry sreg = this.getSessions();
        try {
            this.theSession = sreg.getSession();
            logger.info("Session retrieved: " + this.theSession);
        }
        catch (SessionDoesNotExist e) {
            logger.warning("Session not found for entity " + e.entity);
        }
        catch (ServiceFailure e) {
            throw new ServiceFailure(e.getMessage());
        }
        catch (Throwable t) {
            logger.severe("Unknown error: " + t.getMessage());
            t.printStackTrace();
        }
        try {
            if (this.theSession == null) {
                CollaborationRegistry collab = this.getCollabs();
                this.theSession = collab.createCollaborationSession();
                sreg.registerSession(this.theSession);
            }
            this.obsId = this.theSession.subscribeObserver(this.buildObserver());
            logger.info("Observer subscribed");
            this.consumer = this.buildConsumer();
            this.subsId = this.theSession.channel().subscribe(this.consumer);
            logger.info("Consumer registered");
        }
        catch (ServiceFailure ex) {
            throw new ServiceFailure(ex.getMessage());
        }
        return this.theSession;
    }

    @Override
    public void exitCollaboration() throws ServiceFailure {
        try {
            this.theSession.channel().unsubscribe(this.subsId);
            this.theSession.unsubscribeObserver(this.obsId);
            logger.info("Collaboration finished");
        }
        catch (ServiceFailure e) {
            throw new ServiceFailure(e.getMessage());
        }
        finally {
            this.subsId = 0;
            this.obsId = 0;
            this.theSession = null;
            this.servant = null;
            this.consumer = null;
            this.observer = null;
            this.collabs = null;
            this.sessions = null;
        }
    }

    private CollaborationObserver buildObserver() throws ServiceFailure {
        try {
            ORB orb = this.context.orb();
            this.observer = new SessionObserver(this.context.getCurrentConnection().login().entity);
            POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            byte[] id = poa.activate_object((Servant)this.observer);
            CollaborationObserver ref = CollaborationObserverHelper.narrow(poa.id_to_reference(id));
            return ref;
        }
        catch (Exception e) {
            throw new ServiceFailure(e.getLocalizedMessage(), "Error while session observer activation");
        }
    }

    private EventConsumer buildConsumer() throws ServiceFailure {
        try {
            ORB orb = this.context.orb();
            this.servant = new Consumer();
            POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            byte[] id = poa.activate_object((Servant)this.servant);
            EventConsumer ref = EventConsumerHelper.narrow(poa.id_to_reference(id));
            return ref;
        }
        catch (Exception e) {
            throw new ServiceFailure(e.getLocalizedMessage(), "Error while event consumer activation");
        }
    }

    @Override
    public void shareDataKey(byte[] key) throws ServiceFailure {
        try {
            Any any = this.context.orb().create_any();
            OctetSeqHelper.insert((Any)any, (byte[])key);
            this.theSession.channel().push(any);
        }
        catch (ServiceFailure e) {
            throw new ServiceFailure(e.getMessage());
        }
    }

    @Override
    public void shareDataKeys(List<byte[]> keys) throws ServiceFailure {
        try {
            for (byte[] key : keys) {
                Any any = this.context.orb().create_any();
                OctetSeqHelper.insert((Any)any, (byte[])key);
                this.theSession.channel().push(any);
            }
        }
        catch (ServiceFailure e) {
            throw new ServiceFailure(e.getMessage());
        }
    }

    @Override
    public void shareAny(Any any) throws ServiceFailure {
        try {
            this.theSession.channel().push(any);
        }
        catch (ServiceFailure e) {
            throw new ServiceFailure(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> consumeDataKeys() {
        List list = this.servant.keys;
        synchronized (list) {
            LinkedList<byte[]> list2 = new LinkedList<byte[]>(this.servant.keys);
            this.servant.keys.clear();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Any> consumeAnys() {
        List list = this.servant.anys;
        synchronized (list) {
            LinkedList<Any> list2 = new LinkedList<Any>(this.servant.anys);
            this.servant.anys.clear();
            return list2;
        }
    }

    private SessionRegistry getSessions() throws ServiceFailure {
        if (this.sessions == null || this.sessions._non_existent()) {
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("openbus.component.interface", SessionRegistryHelper.id())};
            List<ServiceOfferDesc> services = Utils.findOffer(this.context.getOfferRegistry(), serviceProperties, 1, 10, 1);
            for (ServiceOfferDesc offerDesc : services) {
                Object obj = offerDesc.service_ref.getFacet(SessionRegistryHelper.id());
                if (obj == null) continue;
                this.sessions = SessionRegistryHelper.narrow(obj);
                if (this.sessions == null) continue;
                break;
            }
        }
        return this.sessions;
    }

    private CollaborationRegistry getCollabs() throws ServiceFailure {
        if (this.collabs == null || this.collabs._non_existent()) {
            ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("openbus.component.interface", CollaborationRegistryHelper.id())};
            List<ServiceOfferDesc> services = Utils.findOffer(this.context.getOfferRegistry(), serviceProperties, 1, 10, 1);
            for (ServiceOfferDesc offerDesc : services) {
                Object obj = offerDesc.service_ref.getFacet(CollaborationRegistryHelper.id());
                if (obj == null) continue;
                this.collabs = CollaborationRegistryHelper.narrow(obj);
                if (this.collabs == null) continue;
                break;
            }
        }
        return this.collabs;
    }

    class SessionObserver
    extends CollaborationObserverPOA {
        private String entity;

        public SessionObserver(String entity) {
            this.entity = entity;
        }

        @Override
        public void memberAdded(String name, IComponent member) throws ServiceFailure {
            logger.info("Member added: " + name);
        }

        @Override
        public void memberRemoved(String name) throws ServiceFailure {
            logger.info("Member removed: " + name);
        }

        @Override
        public void destroyed() throws ServiceFailure {
            logger.info("Session destroyed");
        }
    }

    class Consumer
    extends EventConsumerPOA {
        private List<byte[]> keys = Collections.synchronizedList(new LinkedList());
        private List<Any> anys = Collections.synchronizedList(new LinkedList());

        @Override
        public void push(Any event) throws ServiceFailure {
            logger.info("Received event");
            if (event.type().equivalent(OctetSeqHelper.type())) {
                this.keys.add(OctetSeqHelper.extract((Any)event));
            } else {
                this.anys.add(event);
            }
        }
    }
}

