/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.services.collaboration.easy;

import java.util.ArrayList;
import java.util.List;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

class Utils {
    Utils() {
    }

    static String findProperty(ServiceProperty[] props, String key) {
        for (int i = 0; i < props.length; ++i) {
            ServiceProperty property = props[i];
            if (!property.name.equals(key)) continue;
            return property.value;
        }
        return null;
    }

    static List<ServiceOfferDesc> findOffer(OfferRegistry offers, ServiceProperty[] search, int count, int tries, int interval) throws ServiceFailure {
        ArrayList<ServiceOfferDesc> found = new ArrayList<ServiceOfferDesc>();
        for (int i = 0; i < tries; ++i) {
            found.clear();
            try {
                Thread.sleep(interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ServiceOfferDesc[] services = offers.findServices(search);
            if (services.length > 0) {
                for (ServiceOfferDesc offerDesc : services) {
                    try {
                        if (offerDesc.service_ref._non_existent()) continue;
                        found.add(offerDesc);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (found.size() < count) continue;
            return found;
        }
        StringBuffer buffer = new StringBuffer();
        for (ServiceOfferDesc desc : found) {
            String name = Utils.findProperty(desc.properties, "openbus.offer.entity");
            String login = Utils.findProperty(desc.properties, "openbus.offer.login");
            buffer.append(String.format("\n - %s (%s)", name, login));
        }
        String msg = String.format("n\u00e3o foi poss\u00edvel encontrar ofertas: found (%d) expected(%d) tries (%d) time (%d)%s", found.size(), count, tries, tries * interval, buffer.toString());
        throw new IllegalStateException(msg);
    }
}

