/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import br.pucrio.tecgraf.soma.job.domain.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.domain.model.JobSpecificationType;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;

@Entity
@Table(name="jobs")
public class Job {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="jobs_generator")
    @SequenceGenerator(name="jobs_generator", sequenceName="public.jobs_seq", allocationSize=1)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="job_id", unique=true)
    private String jobId;
    @Column(name="group_id", nullable=true)
    private String groupId = null;
    @Column(name="project_id", nullable=false)
    private String projectId = null;
    @Column(name="user_id", nullable=false)
    private String jobOwner = null;
    @Column(name="auto_machine_selected", nullable=false)
    private Boolean automaticallyMachineSelection = null;
    @ElementCollection
    @CollectionTable(name="job_selected_machines", joinColumns={@JoinColumn(name="job_id")})
    @Column(name="machine_name")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="selected_machine_generator")
    @SequenceGenerator(name="selected_machine_generator", sequenceName="public.job_selected_machines_seq", allocationSize=1)
    @CollectionId(columns={@Column(name="id")}, generator="selected_machine_generator", type=@Type(type="long"))
    private List<String> selectedMachines = new ArrayList<String>();
    @Column(name="number_of_processes", nullable=false)
    private Integer numberOfProcesses = 1;
    @Column(name="number_of_processes_by_machine", nullable=false)
    private Integer numberOfProcessesByMachine = 1;
    @Column(name="submission_time", nullable=false)
    private LocalDateTime submissionTime = null;
    @Column(name="description", nullable=true, length=500)
    private String description = null;
    @Column(name="priority", nullable=false)
    private Integer priority = null;
    @Column(name="multiple_execution", nullable=false)
    private Boolean multipleExecution = false;
    @Column(name="job_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private JobSpecificationType jobType = JobSpecificationType.ALGORITHM;
    @Column(name="number_of_retries", nullable=false)
    private Integer numberOfRetries = 0;
    @Column(name="execution_machine", nullable=true)
    private String executionMachine = null;
    @Column(name="end_time", nullable=true)
    private LocalDateTime endTime = null;
    @Column(name="exit_code", nullable=true)
    private Integer exitCode = null;
    @Column(name="guilty_node_id", nullable=true)
    private String guiltyNodeId = null;
    @Enumerated(value=EnumType.STRING)
    @Column(name="exit_status", nullable=true)
    private ExitStatus exitStatus = null;
    @Column(name="cpu_time", nullable=true)
    private Double cpuTime = null;
    @Column(name="wall_clock_time", nullable=true)
    private Integer wallclockTime = null;
    @Column(name="ram_mem", nullable=true)
    private Double ramMemory = null;
    @OneToMany(mappedBy="job", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<JobStatusHistory> statusHistory = new ArrayList<JobStatusHistory>();
    @Column(name="flow_id", nullable=true)
    private String flowId = null;
    @Column(name="flow_version", nullable=true)
    private String flowVersion;
    @Column(name="flow_name", nullable=true)
    private String flowName;
    @Column(name="flow_raw", nullable=true)
    @Type(type="org.hibernate.type.BinaryType")
    private byte[] flowRaw;
    @Column(name="last_modified_time", nullable=true)
    private LocalDateTime lastModifiedTime = null;
    @OneToMany(mappedBy="job", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<JobAlgorithm> algorithms = new ArrayList<JobAlgorithm>();
    @Column(name="is_deleted", nullable=false)
    private boolean isDeleted = false;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getJobOwner() {
        return this.jobOwner;
    }

    public void setJobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Boolean getAutomaticallyMachineSelection() {
        return this.automaticallyMachineSelection;
    }

    public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
    }

    public List<String> getSelectedMachines() {
        return this.selectedMachines;
    }

    public void setSelectedMachines(List<String> selectedMachines) {
        this.selectedMachines = selectedMachines;
    }

    public Integer getNumberOfProcesses() {
        return this.numberOfProcesses;
    }

    public void setNumberOfProcesses(Integer numberOfProcesses) {
        this.numberOfProcesses = numberOfProcesses;
    }

    public Integer getNumberOfProcessesByMachine() {
        return this.numberOfProcessesByMachine;
    }

    public void setNumberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
        this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    }

    public LocalDateTime getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(LocalDateTime submissionTime) {
        this.submissionTime = submissionTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Boolean getMultipleExecution() {
        return this.multipleExecution;
    }

    public void setMultipleExecution(Boolean multipleExecution) {
        this.multipleExecution = multipleExecution;
    }

    public JobSpecificationType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobSpecificationType jobType) {
        this.jobType = jobType;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public String getExecutionMachine() {
        return this.executionMachine;
    }

    public void setExecutionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public String getGuiltyNodeId() {
        return this.guiltyNodeId;
    }

    public void setGuiltyNodeId(String guiltyNodeId) {
        this.guiltyNodeId = guiltyNodeId;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public Double getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
    }

    public Integer getWallclockTime() {
        return this.wallclockTime;
    }

    public void setWallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
    }

    public Double getRamMemory() {
        return this.ramMemory;
    }

    public void setRamMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
    }

    public List<JobStatusHistory> getStatusHistory() {
        return this.statusHistory;
    }

    public void addStatusHistory(JobStatusHistory jobStatusHistory) {
        jobStatusHistory.setJob(this);
        this.statusHistory.add(jobStatusHistory);
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public byte[] getFlowRaw() {
        return this.flowRaw;
    }

    public void setFlowRaw(byte[] flowRaw) {
        this.flowRaw = flowRaw;
    }

    public LocalDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(LocalDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public List<JobAlgorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void addAlgorithm(JobAlgorithm algorithm) {
        algorithm.setJob(this);
        this.algorithms.add(algorithm);
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }
}

