/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="replica", uniqueConstraints={@UniqueConstraint(name="multiflow_replica_uk", columnNames={"line_number", "multiflow_id"})})
public class Replica {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="replica_generator")
    @SequenceGenerator(name="replica_generator", sequenceName="public.replica_seq", allocationSize=1)
    @Column(name="id", updatable=false, nullable=false)
    private long id;
    @Column(name="line_number", nullable=false)
    private Integer lineNumber = null;
    @ManyToOne
    @JoinColumn(name="multiflow_id", foreignKey=@ForeignKey(name="replica_multiflow_fk"), nullable=false)
    private Multiflow multiflow = null;
    @OneToMany(mappedBy="replica", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<ReplicaJob> replicaJobs = new ArrayList<ReplicaJob>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public Multiflow getMultiflow() {
        return this.multiflow;
    }

    public void setMultiflow(Multiflow multiflow) {
        this.multiflow = multiflow;
    }

    public List<ReplicaJob> getReplicaJobs() {
        return this.replicaJobs;
    }

    public void addReplicaJob(ReplicaJob replicaJob) {
        replicaJob.setReplica(this);
        this.replicaJobs.add(replicaJob);
    }
}

