/*
 * The MIT License
 *
 * Copyright 2015 Antonio Rabelo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.github.tennaito.rsql.builder;

import com.github.tennaito.rsql.jpa.PredicateBuilderStrategy;
import com.github.tennaito.rsql.misc.ArgumentParser;
import com.github.tennaito.rsql.misc.Mapper;

/**
 * Facade Interface for miscelaneous utilities for operation definition.
 * <p>
 * PropertyMapper for translation of properties aliases.
 * ArgumentParser for casting specific types.
 * PredicateBuilder for RSQL AST new nodes.
 *
 * @author AntonioRabelo
 * @since 2015-02-03
 */
public interface BuilderTools {

  /**
   * Get a mapper for the properties.
   *
   * @return Mapper
   */
  Mapper getPropertiesMapper();

  /**
   * Set a specific Mapper.
   *
   * @param mapper Mapper
   */
  void setPropertiesMapper(Mapper mapper);

  /**
   * Get a argument parser for casting types.
   *
   * @return ArgumentParser
   */
  ArgumentParser getArgumentParser();

  /**
   * Set a specific ArgumentParser.
   *
   * @param argumentParser ArgumentParser
   */
  void setArgumentParser(ArgumentParser argumentParser);

  /**
   * Get a predicate strategy for parsing Node into Predicate.
   *
   * @return PredicateBuilderStrategy
   */
  PredicateBuilderStrategy getPredicateBuilder();

  /**
   * Set a specific predicate strategy.
   *
   * @param predicateStrategy PredicateBuilderStrategy
   */
  void setPredicateBuilder(PredicateBuilderStrategy predicateStrategy);
}
