/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.jpa.AbstractJpaVisitor;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JpaCriteriaCountQueryVisitor<T>
extends AbstractJpaVisitor<CriteriaQuery<Long>, T>
implements RSQLVisitor<CriteriaQuery<Long>, EntityManager> {
    private static final Logger LOG = Logger.getLogger(JpaCriteriaCountQueryVisitor.class.getName());
    private final JpaPredicateVisitor<T> predicateVisitor;
    private Root<T> root;

    @SafeVarargs
    public JpaCriteriaCountQueryVisitor(T ... t) {
        super(t);
        this.predicateVisitor = new JpaPredicateVisitor<T>(t);
    }

    protected JpaPredicateVisitor<T> getPredicateVisitor() {
        this.predicateVisitor.setBuilderTools(this.getBuilderTools());
        return this.predicateVisitor;
    }

    public CriteriaQuery<Long> visit(AndNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for AndNode: {0}", node);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        this.root = cq.from(this.entityClass);
        cq.select((Selection)cb.countDistinct(this.root));
        cq.where((Expression)this.getPredicateVisitor().defineRoot((From)this.root).visit(node, entityManager));
        return cq;
    }

    public CriteriaQuery<Long> visit(OrNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for OrNode: {0}", node);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        this.root = cq.from(this.entityClass);
        cq.select((Selection)cb.countDistinct(this.root));
        this.root = cq.from(this.entityClass);
        cq.where((Expression)this.getPredicateVisitor().defineRoot((From)this.root).visit(node, entityManager));
        return cq;
    }

    public CriteriaQuery<Long> visit(ComparisonNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for ComparisonNode: {0}", node);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        this.root = cq.from(this.entityClass);
        cq.select((Selection)cb.countDistinct(this.root));
        cq.where((Expression)this.getPredicateVisitor().defineRoot((From)this.root).visit(node, entityManager));
        return cq;
    }

    public Root<T> getRoot() {
        return this.root;
    }

    public void setRoot(Root<T> root) {
        this.root = root;
    }
}

