package br.pucrio.tecgraf.soma.serviceapi.configuration;

public class ConfigurationOption {

  protected final char shortName;
  protected final String longName, description, valueName, defaultValue;
  protected final int numberOfValues;
  protected final boolean hasValue, areValuesOptional, required;

  public ConfigurationOption(char shortName, String longName, String description, boolean hasValue,
      String valueName, int numberOfValues, boolean areValuesOptional, boolean required,
      String defaultValue) {
    this.shortName = shortName;
    this.longName = longName;
    this.description = description;
    this.hasValue = hasValue;
    this.valueName = valueName;
    this.numberOfValues = numberOfValues;
    this.areValuesOptional = areValuesOptional;
    this.required = required;
    this.defaultValue = defaultValue;
  }

  public char getShortName() {
    return shortName;
  }

  public String getLongName() {
    return longName;
  }

  public String getDescription() {
    return description;
  }

  public String getValueName() {
    return valueName;
  }

  public String getDefaultValue() {
    return defaultValue;
  }

  public int getNumberOfValues() {
    return numberOfValues;
  }

  public boolean isAreValuesOptional() {
    return areValuesOptional;
  }

  public boolean isHasValue() {
    return hasValue;
  }

  public boolean isRequired() {
    return required;
  }

}
