package br.pucrio.tecgraf.soma.serviceapi.persistence.repository;

import java.util.List;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.Specification;

public interface Repository<T, W extends Specification<T>> {

  /**
   * Add an element
   * 
   * @param element to be added
   */
  public void add(T element);

  /**
   * Removes element
   * 
   * @param element element to be removed
   */
  public void remove(T element);

  /**
   * Updates element
   * 
   * @param element new element
   */
  public void update(T element);

  /**
   * Get elements that matches a given specification
   * 
   * @param specification a query specification
   * @param sorts specify one or more attributes that should be used to sort the result
   * @return elements that matches the given specification
   */
  List<T> find(W specification, Sort... sorts);

  /**
   * Get elements that matches a given specification
   * 
   * @param specification a query specification
   * @param maxResult an upper limit to the number of elements returned in the result
   * @param sorts specify one or more attributes that should be used to sort the result
   * @return elements that matches the given specification
   */
  List<T> find(W specification, Integer maxResult, Sort... sorts);

  /**
   * Get elements that matches a given specification
   *
   * @param specification a query specification
   * @param maxResult an upper limit to the number of elements returned in the result
   * @param offset the position of the first result to retrieve.
   * @param sorts specify one or more attributes that should be used to sort the result
   * @return elements that matches the given specification
   */
  List<T> find(W specification, Integer maxResult, Integer offset, Sort... sorts);

  /**
   * Count elements that matches a given specification
   * 
   * @param specification a query specification
   * @return number of elements that matches the given specification
   */
  long count(W specification);

  /**
   * Get the first element that matches a given specification
   * 
   * @param specification a query specification
   * @param sorts specify one or more attributes that should be used to sort the result
   * @return the first element that matches the given specification or null if none matches
   */
  T first(W specification, Sort... sorts);
}
