package br.pucrio.tecgraf.soma.serviceapi.persistence.specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.AndSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.OrSpecification;

public abstract class JPASpecification<T> implements Specification<T> {

	public abstract Predicate toPredicate(Root<T> root, CriteriaBuilder cb);
	
	public <S extends JPASpecification<T>> JPASpecification<T> and(S other) {
		return new AndSpecification<T>(this, other);
	}
	
	public <S extends JPASpecification<T>> JPASpecification<T> or(S other) {
		return new OrSpecification<T>(this, other);
	}

}
