/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.bytebuddy.BulkAccessorException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.bytecode.internal.bytebuddy.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.bytebuddy.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final ByteBuddyState bytebuddy = new ByteBuddyState();
    private static final NamingStrategy.SuffixingRandom instantiatorName = new NamingStrategy.SuffixingRandom("HibernateInstantiator");
    private static final NamingStrategy.SuffixingRandom optimizerName = new NamingStrategy.SuffixingRandom("HibernateAccessOptimizer");
    private static final ElementMatcher.Junction newInstanceMethodName = ElementMatchers.named("newInstance");
    private static final ElementMatcher.Junction getPropertyValuesMethodName = ElementMatchers.named("getPropertyValues");
    private static final ElementMatcher.Junction setPropertyValuesMethodName = ElementMatchers.named("setPropertyValues");
    private static final ElementMatcher.Junction getPropertyNamesMethodName = ElementMatchers.named("getPropertyNames");

    @Override
    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl(bytebuddy);
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        Method[] getters = new Method[getterNames.length];
        Method[] setters = new Method[setterNames.length];
        BytecodeProviderImpl.findAccessors(clazz, getterNames, setterNames, types, getters, setters);
        Constructor<?> constructor = BytecodeProviderImpl.findConstructor(clazz);
        Class fastClass = bytebuddy.getCurrentyByteBuddy().with(instantiatorName).subclass(ReflectionOptimizer.InstantiationOptimizer.class).method(newInstanceMethodName).intercept(MethodCall.construct(constructor)).make().load(clazz.getClassLoader()).getLoaded();
        Class bulkAccessor = bytebuddy.getCurrentyByteBuddy().with(optimizerName).subclass(ReflectionOptimizer.AccessOptimizer.class).method(getPropertyValuesMethodName).intercept(new Implementation.Simple(new GetPropertyValues(clazz, getters))).method(setPropertyValuesMethodName).intercept(new Implementation.Simple(new SetPropertyValues(clazz, setters))).method(getPropertyNamesMethodName).intercept(MethodCall.call(new CloningPropertyCall(getterNames))).make().load(clazz.getClassLoader()).getLoaded();
        try {
            return new ReflectionOptimizerImpl((ReflectionOptimizer.InstantiationOptimizer)fastClass.newInstance(), (ReflectionOptimizer.AccessOptimizer)bulkAccessor.newInstance());
        }
        catch (Exception exception) {
            throw new HibernateException(exception);
        }
    }

    private static void findAccessors(Class clazz, String[] getterNames, String[] setterNames, Class[] types, Method[] getters, Method[] setters) {
        int length = types.length;
        if (setterNames.length != length || getterNames.length != length) {
            throw new BulkAccessorException("bad number of accessors");
        }
        Class[] getParam = new Class[]{};
        Class[] setParam = new Class[1];
        for (int i = 0; i < length; ++i) {
            if (getterNames[i] != null) {
                Method getter = BytecodeProviderImpl.findAccessor(clazz, getterNames[i], getParam, i);
                if (getter.getReturnType() != types[i]) {
                    throw new BulkAccessorException("wrong return type: " + getterNames[i], i);
                }
                getters[i] = getter;
            }
            if (setterNames[i] == null) continue;
            setParam[0] = types[i];
            setters[i] = BytecodeProviderImpl.findAccessor(clazz, setterNames[i], setParam, i);
        }
    }

    private static Method findAccessor(Class clazz, String name, Class[] params, int index) throws BulkAccessorException {
        try {
            Method method = clazz.getDeclaredMethod(name, params);
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new BulkAccessorException("private property", index);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new BulkAccessorException("cannot find an accessor", index);
        }
    }

    private static Constructor<?> findConstructor(Class clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(e);
        }
    }

    @Override
    public Enhancer getEnhancer(EnhancementContext enhancementContext) {
        return new EnhancerImpl(enhancementContext, bytebuddy);
    }

    @Override
    public void resetCaches() {
        bytebuddy.clearState();
    }

    public static class CloningPropertyCall
    implements Callable<String[]> {
        private final String[] propertyNames;

        private CloningPropertyCall(String[] propertyNames) {
            this.propertyNames = propertyNames;
        }

        @Override
        public String[] call() {
            return (String[])this.propertyNames.clone();
        }
    }

    private static class SetPropertyValues
    implements ByteCodeAppender {
        private final Class clazz;
        private final Method[] setters;

        public SetPropertyValues(Class clazz, Method[] setters) {
            this.clazz = clazz;
            this.setters = setters;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            int index = 0;
            for (Method setter : this.setters) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitLdcInsn(index++);
                methodVisitor.visitInsn(50);
                if (setter.getParameterTypes()[0].isPrimitive()) {
                    PrimitiveUnboxingDelegate.forReferenceType(TypeDescription.Generic.OBJECT).assignUnboxedTo(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(setter.getParameterTypes()[0]), ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.DYNAMIC).apply(methodVisitor, implementationContext);
                } else {
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(setter.getParameterTypes()[0]));
                }
                methodVisitor.visitMethodInsn(182, Type.getInternalName(this.clazz), setter.getName(), Type.getMethodDescriptor(setter), false);
            }
            methodVisitor.visitInsn(177);
            return new ByteCodeAppender.Size(4, instrumentedMethod.getStackSize());
        }
    }

    private static class GetPropertyValues
    implements ByteCodeAppender {
        private final Class clazz;
        private final Method[] getters;

        public GetPropertyValues(Class clazz, Method[] getters) {
            this.clazz = clazz;
            this.getters = getters;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            methodVisitor.visitLdcInsn(this.getters.length);
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Object.class));
            int index = 0;
            for (Method getter : this.getters) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn(index++);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                methodVisitor.visitMethodInsn(182, Type.getInternalName(this.clazz), getter.getName(), Type.getMethodDescriptor(getter), false);
                if (getter.getReturnType().isPrimitive()) {
                    PrimitiveBoxingDelegate.forPrimitive(new TypeDescription.ForLoadedType(getter.getReturnType())).assignBoxedTo(TypeDescription.Generic.OBJECT, ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.STATIC).apply(methodVisitor, implementationContext);
                }
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(176);
            return new ByteCodeAppender.Size(6, instrumentedMethod.getStackSize());
        }
    }
}

