/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.yaml.SpringProfileDocumentMatcher;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlPropertySourceLoader
implements PropertySourceLoader {
    @Override
    public String[] getFileExtensions() {
        return new String[]{"yml", "yaml"};
    }

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile2) throws IOException {
        Processor processor;
        Map<String, Object> source;
        if (ClassUtils.isPresent("org.yaml.snakeyaml.Yaml", null) && !(source = (processor = new Processor(resource, profile2)).process()).isEmpty()) {
            return new MapPropertySource(name, source);
        }
        return null;
    }

    private static class Processor
    extends YamlProcessor {
        Processor(Resource resource, String profile2) {
            if (profile2 == null) {
                this.setMatchDefault(true);
                this.setDocumentMatchers(new SpringProfileDocumentMatcher());
            } else {
                this.setMatchDefault(false);
                this.setDocumentMatchers(new SpringProfileDocumentMatcher(profile2));
            }
            this.setResources(resource);
        }

        @Override
        protected Yaml createYaml() {
            return new Yaml((BaseConstructor)new YamlProcessor.StrictMapAppenderConstructor(), new Representer(), new DumperOptions(), new Resolver(){

                @Override
                public void addImplicitResolver(Tag tag, Pattern regexp, String first) {
                    if (tag == Tag.TIMESTAMP) {
                        return;
                    }
                    super.addImplicitResolver(tag, regexp, first);
                }
            });
        }

        public Map<String, Object> process() {
            final LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.process(new YamlProcessor.MatchCallback(){

                @Override
                public void process(Properties properties, Map<String, Object> map) {
                    result.putAll(Processor.this.getFlattenedMap(map));
                }
            });
            return result;
        }
    }
}

