/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.utils.zookeeper;

import io.confluent.common.utils.zookeeper.ConditionalUpdateCallback;
import io.confluent.common.utils.zookeeper.ZkData;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUtils {
    private static final Logger log = LoggerFactory.getLogger(ZkUtils.class);

    public static void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private static void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    public static void createPersistentPath(ZkClient client, String path, String data) {
        try {
            client.createPersistent(path, data);
        }
        catch (ZkNoNodeException nne) {
            ZkUtils.createParentPath(client, path);
            client.createPersistent(path, data);
        }
    }

    public static void updatePersistentPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, data);
        }
        catch (ZkNoNodeException nne) {
            ZkUtils.createParentPath(client, path);
            try {
                client.createPersistent(path, data);
            }
            catch (ZkNodeExistsException nee) {
                client.writeData(path, data);
            }
        }
    }

    public static ZkData readData(ZkClient client, String path) {
        Stat stat = new Stat();
        String data = (String)client.readData(path, stat);
        return new ZkData(data, stat);
    }

    public static ZkData readDataMaybeNull(ZkClient client, String path) {
        Stat stat = new Stat();
        String data = (String)client.readData(path, stat);
        return new ZkData(data, stat);
    }

    public static int conditionalUpdatePersistentPath(ZkClient client, String path, String data, int expectedVersion, ConditionalUpdateCallback customConditionCallback) {
        try {
            Stat stat = client.writeDataReturnStat(path, data, expectedVersion);
            log.debug(String.format(path, data, expectedVersion, stat.getVersion()));
            return stat.getVersion();
        }
        catch (ZkBadVersionException bve) {
            if (customConditionCallback != null) {
                return customConditionCallback.checker(client, path, data);
            }
            log.warn(String.format(path, data, expectedVersion, bve.getMessage()));
            return -1;
        }
        catch (Exception e) {
            log.warn(String.format(path, data, expectedVersion, e.getMessage()));
            return -1;
        }
    }
}

