/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.predicate;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterContainer;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.predicate.AbstractSimplePredicate;

public class BooleanAssertionPredicate
extends AbstractSimplePredicate
implements Serializable {
    private final Expression<Boolean> expression;
    private final Boolean assertedValue;

    public BooleanAssertionPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<Boolean> expression, Boolean assertedValue) {
        super(criteriaBuilder);
        this.expression = expression;
        this.assertedValue = assertedValue;
    }

    public Expression<Boolean> getExpression() {
        return this.expression;
    }

    public Boolean getAssertedValue() {
        return this.assertedValue;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.expression, registry);
    }

    @Override
    public String render(boolean isNegated, RenderingContext renderingContext) {
        String operator = isNegated ? " <> " : " = ";
        String assertionLiteral = this.assertedValue != false ? "true" : "false";
        return ((Renderable)((Object)this.expression)).render(renderingContext) + operator + assertionLiteral;
    }
}

