/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.event.spi.jpa.Listener;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;

public class ListenerFactoryStandardImpl
implements ListenerFactory {
    private final ConcurrentHashMap<Class, ListenerImpl> listenerInstances = new ConcurrentHashMap();

    @Override
    public <T> Listener<T> buildListener(Class<T> listenerClass) {
        ListenerImpl<T> listenerImpl = this.listenerInstances.get(listenerClass);
        if (listenerImpl == null) {
            try {
                T listenerInstance = listenerClass.newInstance();
                listenerImpl = new ListenerImpl<T>(listenerInstance);
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to create instance of " + listenerClass.getName() + " as a JPA callback listener", e);
            }
            ListenerImpl<T> existing = this.listenerInstances.putIfAbsent(listenerClass, listenerImpl);
            if (existing != null) {
                listenerImpl = existing;
            }
        }
        return listenerImpl;
    }

    @Override
    public void release() {
        this.listenerInstances.clear();
    }

    private static class ListenerImpl<T>
    implements Listener<T> {
        private final T listenerInstance;

        public ListenerImpl(T listenerInstance) {
            this.listenerInstance = listenerInstance;
        }

        @Override
        public T getListener() {
            return this.listenerInstance;
        }
    }
}

