/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import org.hibernate.internal.CoreLogging;
import org.hibernate.tool.schema.internal.exec.AbstractScriptTargetOutput;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToFile;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.jboss.logging.Logger;

public class ScriptTargetOutputToUrl
extends AbstractScriptTargetOutput
implements ScriptTargetOutput {
    private static final Logger log = CoreLogging.logger(ScriptTargetOutputToUrl.class);
    private final URL url;
    private final String charsetName;
    private Writer writer;

    public ScriptTargetOutputToUrl(URL url, String charsetName) {
        this.url = url;
        this.charsetName = charsetName;
    }

    @Override
    protected Writer writer() {
        if (this.writer == null) {
            throw new SchemaManagementException("Illegal state : writer null - not prepared");
        }
        return this.writer;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.writer = ScriptTargetOutputToUrl.toWriter(this.url, this.charsetName);
    }

    @Override
    public void release() {
        try {
            this.writer().close();
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to close file writer : " + e.toString());
        }
    }

    private static Writer toWriter(URL url, String charsetName) {
        log.debug("Attempting to resolve writer for URL : " + url);
        try {
            return ScriptTargetOutputToFile.toFileWriter(new File(url.toURI()), charsetName);
        }
        catch (URISyntaxException e) {
            throw new SchemaManagementException(String.format("Could not convert specified URL[%s] to a File reference", url), e);
        }
    }
}

