/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class EnumConverter
implements ConditionalConverter<Object, Enum<?>> {
    EnumConverter() {
    }

    @Override
    public Enum<?> convert(MappingContext<Object, Enum<?>> context) {
        String name;
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        String string = name = source.getClass() == String.class ? (String)source : ((Enum)source).name();
        if (name != null) {
            try {
                return Enum.valueOf(context.getDestinationType(), name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return destinationType.isEnum() && (sourceType.isEnum() || sourceType == String.class) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }
}

