/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.integration;

import javax.management.MBeanServer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.integration.IntegrationAutoConfigurationScanRegistrar;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.jmx.config.EnableIntegrationMBeanExport;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EnableIntegration.class})
@AutoConfigureAfter(value={JmxAutoConfiguration.class})
public class IntegrationAutoConfiguration {

    @ConditionalOnMissingBean(value={GatewayProxyFactoryBean.class})
    @Import(value={IntegrationAutoConfigurationScanRegistrar.class})
    protected static class IntegrationComponentScanAutoConfiguration {
        protected IntegrationComponentScanAutoConfiguration() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationManagement.class, EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
    @ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class IntegrationManagementConfiguration {
        protected IntegrationManagementConfiguration() {
        }

        @Configuration
        @EnableIntegrationManagement(defaultCountsEnabled="true", defaultStatsEnabled="true")
        protected static class EnableIntegrationManagementConfiguration {
            protected EnableIntegrationManagementConfiguration() {
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationMBeanExport.class})
    @ConditionalOnMissingBean(value={IntegrationMBeanExporter.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnProperty(prefix="spring.jmx", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class IntegrationJmxConfiguration
    implements EnvironmentAware,
    BeanFactoryAware {
        private BeanFactory beanFactory;
        private RelaxedPropertyResolver propertyResolver;

        protected IntegrationJmxConfiguration() {
        }

        @Override
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        @Override
        public void setEnvironment(Environment environment2) {
            this.propertyResolver = new RelaxedPropertyResolver(environment2, "spring.jmx.");
        }

        @Bean
        public IntegrationMBeanExporter integrationMbeanExporter() {
            String server;
            IntegrationMBeanExporter exporter = new IntegrationMBeanExporter();
            String defaultDomain = this.propertyResolver.getProperty("default-domain");
            if (StringUtils.hasLength(defaultDomain)) {
                exporter.setDefaultDomain(defaultDomain);
            }
            if (StringUtils.hasLength(server = this.propertyResolver.getProperty("server", "mbeanServer"))) {
                exporter.setServer(this.beanFactory.getBean(server, MBeanServer.class));
            }
            return exporter;
        }
    }

    @Configuration
    @EnableIntegration
    protected static class IntegrationConfiguration {
        protected IntegrationConfiguration() {
        }
    }
}

