/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class ThymeleafTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment2, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent("org.thymeleaf.spring4.SpringTemplateEngine", classLoader)) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(environment2, "spring.thymeleaf.");
            String prefix = resolver.getProperty("prefix", "classpath:/templates/");
            String suffix = resolver.getProperty("suffix", ".html");
            return resourceLoader.getResource(prefix + view + suffix).exists();
        }
        return false;
    }
}

