/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.transaction.jta;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.jndi.BitronixContext;
import java.io.File;
import javax.jms.Message;
import javax.transaction.TransactionManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ApplicationHome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jta.XAConnectionFactoryWrapper;
import org.springframework.boot.jta.XADataSourceWrapper;
import org.springframework.boot.jta.bitronix.BitronixDependentBeanFactoryPostProcessor;
import org.springframework.boot.jta.bitronix.BitronixXAConnectionFactoryWrapper;
import org.springframework.boot.jta.bitronix.BitronixXADataSourceWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={JtaProperties.class})
@ConditionalOnClass(value={JtaTransactionManager.class, BitronixContext.class})
@ConditionalOnMissingBean(value={PlatformTransactionManager.class})
class BitronixJtaConfiguration {
    private final JtaProperties jtaProperties;
    private final TransactionManagerCustomizers transactionManagerCustomizers;

    BitronixJtaConfiguration(JtaProperties jtaProperties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.jtaProperties = jtaProperties;
        this.transactionManagerCustomizers = transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.jta.bitronix.properties")
    public Configuration bitronixConfiguration() {
        Configuration config = TransactionManagerServices.getConfiguration();
        if (StringUtils.hasText(this.jtaProperties.getTransactionManagerId())) {
            config.setServerId(this.jtaProperties.getTransactionManagerId());
        }
        File logBaseDir = this.getLogBaseDir();
        config.setLogPart1Filename(new File(logBaseDir, "part1.btm").getAbsolutePath());
        config.setLogPart2Filename(new File(logBaseDir, "part2.btm").getAbsolutePath());
        config.setDisableJmx(true);
        return config;
    }

    private File getLogBaseDir() {
        if (StringUtils.hasLength(this.jtaProperties.getLogDir())) {
            return new File(this.jtaProperties.getLogDir());
        }
        File home = new ApplicationHome().getDir();
        return new File(home, "transaction-logs");
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionManager.class})
    public BitronixTransactionManager bitronixTransactionManager(Configuration configuration) {
        return TransactionManagerServices.getTransactionManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
    public BitronixXADataSourceWrapper xaDataSourceWrapper() {
        return new BitronixXADataSourceWrapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public static BitronixDependentBeanFactoryPostProcessor bitronixDependentBeanFactoryPostProcessor() {
        return new BitronixDependentBeanFactoryPostProcessor();
    }

    @Bean
    public JtaTransactionManager transactionManager(TransactionManager transactionManager) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(transactionManager);
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize(jtaTransactionManager);
        }
        return jtaTransactionManager;
    }

    @ConditionalOnClass(value={Message.class})
    static class BitronixJtaJmsConfiguration {
        BitronixJtaJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        public BitronixXAConnectionFactoryWrapper xaConnectionFactoryWrapper() {
            return new BitronixXAConnectionFactoryWrapper();
        }
    }
}

