/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.OriginCapablePropertyValue;
import org.springframework.boot.bind.PatternPropertyNamePatternsMatcher;
import org.springframework.boot.bind.PropertyNamePatternsMatcher;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;

public class PropertySourcesPropertyValues
implements PropertyValues {
    private static final Pattern COLLECTION_PROPERTY = Pattern.compile("\\[(\\d+)\\](\\.\\S+)?");
    private final PropertySources propertySources;
    private final Collection<String> nonEnumerableFallbackNames;
    private final PropertyNamePatternsMatcher includes;
    private final Map<String, PropertyValue> propertyValues = new LinkedHashMap<String, PropertyValue>();
    private final ConcurrentHashMap<String, PropertySource<?>> collectionOwners = new ConcurrentHashMap();
    private final boolean resolvePlaceholders;

    public PropertySourcesPropertyValues(PropertySources propertySources) {
        this(propertySources, true);
    }

    public PropertySourcesPropertyValues(PropertySources propertySources, boolean resolvePlaceholders) {
        this(propertySources, null, PropertyNamePatternsMatcher.ALL, resolvePlaceholders);
    }

    public PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> includePatterns, Collection<String> nonEnumerableFallbackNames) {
        this(propertySources, nonEnumerableFallbackNames, new PatternPropertyNamePatternsMatcher(includePatterns), true);
    }

    PropertySourcesPropertyValues(PropertySources propertySources, Collection<String> nonEnumerableFallbackNames, PropertyNamePatternsMatcher includes, boolean resolvePlaceholders) {
        Assert.notNull((Object)propertySources, "PropertySources must not be null");
        Assert.notNull((Object)includes, "Includes must not be null");
        this.propertySources = propertySources;
        this.nonEnumerableFallbackNames = nonEnumerableFallbackNames;
        this.includes = includes;
        this.resolvePlaceholders = resolvePlaceholders;
        PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(propertySources);
        for (PropertySource source : propertySources) {
            this.processPropertySource(source, resolver);
        }
    }

    private void processPropertySource(PropertySource<?> source, PropertySourcesPropertyResolver resolver) {
        if (source instanceof CompositePropertySource) {
            this.processCompositePropertySource((CompositePropertySource)source, resolver);
        } else if (source instanceof EnumerablePropertySource) {
            this.processEnumerablePropertySource((EnumerablePropertySource)source, resolver, this.includes);
        } else {
            this.processNonEnumerablePropertySource(source, resolver);
        }
    }

    private void processCompositePropertySource(CompositePropertySource source, PropertySourcesPropertyResolver resolver) {
        for (PropertySource<?> nested : source.getPropertySources()) {
            this.processPropertySource(nested, resolver);
        }
    }

    private void processEnumerablePropertySource(EnumerablePropertySource<?> source, PropertySourcesPropertyResolver resolver, PropertyNamePatternsMatcher includes) {
        if (source.getPropertyNames().length > 0) {
            for (String propertyName : source.getPropertyNames()) {
                if (!includes.matches(propertyName)) continue;
                Object value = this.getEnumerableProperty(source, resolver, propertyName);
                this.putIfAbsent(propertyName, value, source);
            }
        }
    }

    private Object getEnumerableProperty(EnumerablePropertySource<?> source, PropertySourcesPropertyResolver resolver, String propertyName) {
        try {
            if (this.resolvePlaceholders) {
                return resolver.getProperty(propertyName, Object.class);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return source.getProperty(propertyName);
    }

    private void processNonEnumerablePropertySource(PropertySource<?> source, PropertySourcesPropertyResolver resolver) {
        if (this.nonEnumerableFallbackNames == null) {
            return;
        }
        for (String propertyName : this.nonEnumerableFallbackNames) {
            if (!source.containsProperty(propertyName)) continue;
            Object value = null;
            try {
                value = resolver.getProperty(propertyName, Object.class);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (value == null) {
                value = source.getProperty(propertyName.toUpperCase());
            }
            this.putIfAbsent(propertyName, value, source);
        }
    }

    @Override
    public PropertyValue[] getPropertyValues() {
        Collection<PropertyValue> values = this.propertyValues.values();
        return values.toArray(new PropertyValue[values.size()]);
    }

    @Override
    public PropertyValue getPropertyValue(String propertyName) {
        PropertyValue propertyValue = this.propertyValues.get(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        for (PropertySource source : this.propertySources) {
            Object value = source.getProperty(propertyName);
            propertyValue = this.putIfAbsent(propertyName, value, source);
            if (propertyValue == null) continue;
            return propertyValue;
        }
        return null;
    }

    private PropertyValue putIfAbsent(String propertyName, Object value, PropertySource<?> source) {
        PropertySource<?> collectionOwner;
        if (!(value == null || this.propertyValues.containsKey(propertyName) || (collectionOwner = this.collectionOwners.putIfAbsent(COLLECTION_PROPERTY.matcher(propertyName).replaceAll("[]"), source)) != null && collectionOwner != source)) {
            OriginCapablePropertyValue propertyValue = new OriginCapablePropertyValue(propertyName, value, propertyName, source);
            this.propertyValues.put(propertyName, propertyValue);
            return propertyValue;
        }
        return null;
    }

    @Override
    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        for (PropertyValue newValue : this.getPropertyValues()) {
            PropertyValue oldValue = old.getPropertyValue(newValue.getName());
            if (oldValue != null && oldValue.equals(newValue)) continue;
            changes.addPropertyValue(newValue);
        }
        return changes;
    }

    @Override
    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.propertyValues.isEmpty();
    }
}

