/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class EnumerableCompositePropertySource
extends EnumerablePropertySource<Collection<PropertySource<?>>> {
    private volatile String[] names;

    public EnumerableCompositePropertySource(String sourceName) {
        super(sourceName, new LinkedHashSet());
    }

    @Override
    public Object getProperty(String name) {
        for (PropertySource propertySource : (Collection)this.getSource()) {
            Object value = propertySource.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        String[] result = this.names;
        if (result == null) {
            ArrayList<String> names = new ArrayList<String>();
            for (PropertySource source : new ArrayList((Collection)this.getSource())) {
                if (!(source instanceof EnumerablePropertySource)) continue;
                names.addAll(Arrays.asList(((EnumerablePropertySource)source).getPropertyNames()));
            }
            this.names = names.toArray(new String[0]);
            result = this.names;
        }
        return result;
    }

    public void add(PropertySource<?> source) {
        ((Collection)this.getSource()).add(source);
        this.names = null;
    }
}

