/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import liquibase.logging.LogFactory;
import liquibase.servicelocator.CustomResolverServiceLocator;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.ServiceLocator;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.liquibase.CommonsLoggingLiquibaseLogger;
import org.springframework.boot.liquibase.SpringPackageScanClassResolver;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ClassUtils;

public class LiquibaseServiceLocatorApplicationListener
implements ApplicationListener<ApplicationStartingEvent> {
    private static final Log logger = org.apache.commons.logging.LogFactory.getLog(LiquibaseServiceLocatorApplicationListener.class);

    @Override
    public void onApplicationEvent(ApplicationStartingEvent event) {
        if (ClassUtils.isPresent("liquibase.servicelocator.ServiceLocator", null)) {
            new LiquibasePresent().replaceServiceLocator();
        }
    }

    private static class LiquibasePresent {
        private LiquibasePresent() {
        }

        public void replaceServiceLocator() {
            CustomResolverServiceLocator customResolverServiceLocator = new CustomResolverServiceLocator((PackageScanClassResolver)new SpringPackageScanClassResolver(logger));
            customResolverServiceLocator.addPackageToScan(CommonsLoggingLiquibaseLogger.class.getPackage().getName());
            ServiceLocator.setInstance((ServiceLocator)customResolverServiceLocator);
            LogFactory.reset();
        }
    }
}

