/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.DefaultRepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class RepositoryConfigurationExtensionSupport
implements RepositoryConfigurationExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryConfigurationExtensionSupport.class);
    private static final String CLASS_LOADING_ERROR = "%s - Could not load type %s using class loader %s.";
    private static final String MULTI_STORE_DROPPED = "Spring Data {} - Could not safely identify store assignment for repository candidate {}.";

    @Override
    public String getModuleName() {
        return StringUtils.capitalize(this.getModulePrefix());
    }

    @Override
    public <T extends RepositoryConfigurationSource> Collection<RepositoryConfiguration<T>> getRepositoryConfigurations(T configSource, ResourceLoader loader) {
        return this.getRepositoryConfigurations(configSource, loader, false);
    }

    @Override
    public <T extends RepositoryConfigurationSource> Collection<RepositoryConfiguration<T>> getRepositoryConfigurations(T configSource, ResourceLoader loader, boolean strictMatchesOnly) {
        Assert.notNull(configSource, "ConfigSource must not be null!");
        Assert.notNull((Object)loader, "Loader must not be null!");
        HashSet<RepositoryConfiguration<T>> result = new HashSet<RepositoryConfiguration<T>>();
        for (BeanDefinition candidate : configSource.getCandidates(loader)) {
            RepositoryConfiguration<T> configuration = this.getRepositoryConfiguration(candidate, configSource);
            if (!strictMatchesOnly || configSource.usesExplicitFilters()) {
                result.add(configuration);
                continue;
            }
            Class<?> repositoryInterface = this.loadRepositoryInterface(configuration, loader);
            if (repositoryInterface != null && !this.isStrictRepositoryCandidate(repositoryInterface)) continue;
            result.add(configuration);
        }
        return result;
    }

    @Override
    public String getDefaultNamedQueryLocation() {
        return String.format("classpath*:META-INF/%s-named-queries.properties", this.getModulePrefix());
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
    }

    protected abstract String getModulePrefix();

    @Override
    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptySet();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.emptySet();
    }

    public static String registerWithSourceAndGeneratedBeanName(BeanDefinitionRegistry registry, AbstractBeanDefinition bean2, Object source) {
        bean2.setSource(source);
        String beanName = BeanDefinitionReaderUtils.generateBeanName(bean2, registry);
        registry.registerBeanDefinition(beanName, bean2);
        return beanName;
    }

    public static void registerIfNotAlreadyRegistered(AbstractBeanDefinition bean2, BeanDefinitionRegistry registry, String beanName, Object source) {
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        bean2.setSource(source);
        registry.registerBeanDefinition(beanName, bean2);
    }

    public static boolean hasBean(Class<?> type, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", type.getName(), "#");
        return registry.containsBeanDefinition(name);
    }

    protected <T extends RepositoryConfigurationSource> RepositoryConfiguration<T> getRepositoryConfiguration(BeanDefinition definition, T configSource) {
        return new DefaultRepositoryConfiguration<T>(configSource, definition);
    }

    protected boolean isStrictRepositoryCandidate(Class<?> repositoryInterface) {
        RepositoryMetadata metadata = AbstractRepositoryMetadata.getMetadata(repositoryInterface);
        Collection<Class<?>> types = this.getIdentifyingTypes();
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(repositoryInterface)) continue;
            return true;
        }
        Class<?> domainType = metadata.getDomainType();
        Collection<Class<? extends Annotation>> annotations = this.getIdentifyingAnnotations();
        if (annotations.isEmpty()) {
            return true;
        }
        for (Class<? extends Annotation> annotationType : annotations) {
            if (AnnotationUtils.findAnnotation(domainType, annotationType) == null) continue;
            return true;
        }
        LOGGER.info(MULTI_STORE_DROPPED, (Object)this.getModuleName(), (Object)repositoryInterface);
        return false;
    }

    private Class<?> loadRepositoryInterface(RepositoryConfiguration<?> configuration, ResourceLoader loader) {
        String repositoryInterface = configuration.getRepositoryInterface();
        ClassLoader classLoader = loader.getClassLoader();
        try {
            return ClassUtils.forName(repositoryInterface, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(String.format(CLASS_LOADING_ERROR, this.getModuleName(), repositoryInterface, classLoader), e);
        }
        catch (LinkageError e) {
            LOGGER.warn(String.format(CLASS_LOADING_ERROR, this.getModuleName(), repositoryInterface, classLoader), e);
        }
        return null;
    }
}

