/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javaslang.collection.LinkedHashMap;
import javaslang.collection.LinkedHashSet;
import javaslang.collection.Map;
import javaslang.collection.Seq;
import javaslang.collection.Traversable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.util.ReflectionUtils;

class JavaslangCollections {
    JavaslangCollections() {
    }

    public static enum FromJavaConverter implements ConditionalGenericConverter
    {
        INSTANCE{

            @Override
            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return CONVERTIBLE_PAIRS;
            }

            @Override
            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType.isCollection() && Map.class.isAssignableFrom(targetType.getType())) {
                    return false;
                }
                return !sourceType.isMap() || Map.class.isAssignableFrom(targetType.getType()) || targetType.getType().equals(Traversable.class);
            }

            @Override
            public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (source instanceof List) {
                    return ReflectionUtils.invokeMethod(LIST_FACTORY_METHOD, null, source);
                }
                if (source instanceof Set) {
                    return ReflectionUtils.invokeMethod(SET_FACTORY_METHOD, null, source);
                }
                if (source instanceof java.util.Map) {
                    return ReflectionUtils.invokeMethod(MAP_FACTORY_METHOD, null, source);
                }
                return source;
            }
        };

        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;
        private static final Method LIST_FACTORY_METHOD;
        private static final Method SET_FACTORY_METHOD;
        private static final Method MAP_FACTORY_METHOD;

        static {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
            pairs.add(new GenericConverter.ConvertiblePair(Collection.class, Traversable.class));
            pairs.add(new GenericConverter.ConvertiblePair(java.util.Map.class, Traversable.class));
            CONVERTIBLE_PAIRS = Collections.unmodifiableSet(pairs);
            MAP_FACTORY_METHOD = ReflectionUtils.findMethod(LinkedHashMap.class, "ofAll", java.util.Map.class);
            LIST_FACTORY_METHOD = ReflectionUtils.findMethod(javaslang.collection.List.class, "ofAll", Iterable.class);
            SET_FACTORY_METHOD = ReflectionUtils.findMethod(LinkedHashSet.class, "ofAll", Iterable.class);
        }
    }

    public static enum ToJavaConverter implements Converter<Object, Object>
    {
        INSTANCE;


        public QueryExecutionConverters.WrapperType getWrapperType() {
            return QueryExecutionConverters.WrapperType.multiValue(Traversable.class);
        }

        @Override
        public Object convert(Object source) {
            if (source instanceof Seq) {
                return ((Seq)source).toJavaList();
            }
            if (source instanceof Map) {
                return ((Map)source).toJavaMap();
            }
            if (source instanceof javaslang.collection.Set) {
                return ((javaslang.collection.Set)source).toJavaSet();
            }
            throw new IllegalArgumentException("Unsupported Javaslang collection " + source);
        }
    }
}

