/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.web.querydsl.QuerydslPredicateArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class QuerydslWebConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    @Qualifier(value="mvcConversionService")
    ObjectFactory<ConversionService> conversionService;

    @Lazy
    @Bean
    public QuerydslPredicateArgumentResolver querydslPredicateArgumentResolver() {
        return new QuerydslPredicateArgumentResolver(this.querydslBindingsFactory(), this.conversionService.getObject());
    }

    @Lazy
    @Bean
    public QuerydslBindingsFactory querydslBindingsFactory() {
        return new QuerydslBindingsFactory(SimpleEntityPathResolver.INSTANCE);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(0, this.querydslPredicateArgumentResolver());
    }
}

