/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.ExitStatusConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToDoubleConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToIntegerConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToLocalDateTimeConverter;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class FinishedJobMapper {
    private static final String TYPE_MAP_NAME = "JobFinishedEventToJob";
    private static FinishedJobMapper instance;
    private final ModelMapper modelMapper = new ModelMapper();
    private final TypeMap<JobFinishedEvent, Job> typeMap;

    private FinishedJobMapper() {
        this.modelMapper.getConfiguration().setAmbiguityIgnored(true);
        this.modelMapper.getConfiguration().setSkipNullEnabled(true);
        this.typeMap = this.modelMapper.createTypeMap(JobFinishedEvent.class, Job.class, TYPE_MAP_NAME);
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setJobId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setGroupId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setProjectId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setAutomaticallyMachineSelection));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setSelectedMachines));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcesses));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcessesByMachine));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setSubmissionTime));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setDescription));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setMultipleExecution));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfRetries));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setExecutionMachine));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setJobOwner));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setJobType));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setRamMemory));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowId));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowVersion));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowName));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setFlowRaw));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setPriority));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setDeleted));
        this.typeMap.addMappings(mapper -> mapper.skip(Job::setProgress));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new LongToLocalDateTimeConverter()).map(JobFinishedEvent::getTimestamp, Job::setLastModifiedTime));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new ExitStatusConverter()).map(JobFinishedEvent::getExitStatus, Job::setExitStatus));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new LongToIntegerConverter()).map(JobFinishedEvent::getWallclockTime, Job::setWallclockTime));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new LongToDoubleConverter()).map(JobFinishedEvent::getCpuTime, Job::setCpuTime));
        this.typeMap.addMappings(mapper -> mapper.using((Converter)new LongToLocalDateTimeConverter()).map(JobFinishedEvent::getEndTime, Job::setEndTime));
        this.modelMapper.validate();
    }

    public static FinishedJobMapper getInstance() {
        if (instance == null) {
            instance = new FinishedJobMapper();
        }
        return instance;
    }

    public void map(JobFinishedEvent event, Job job) {
        this.modelMapper.map((Object)event, (Object)job, TYPE_MAP_NAME);
    }
}

