package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import org.springframework.stereotype.Repository;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;

@Repository
public class JobRepository extends JPARepository<Job> {

  @PersistenceContext
  private EntityManager _entityManager;

  @Override
  public EntityManager getEntityManager() {
    return _entityManager;
  }

  public void setEntityManager(EntityManager entityManager) {
    this._entityManager = entityManager;
  }

  @Override
  public Class<Job> getType() {
    return Job.class;
  }

}
