package br.pucrio.tecgraf.soma.job.domain;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import org.springframework.web.socket.TextMessage;

import java.util.ArrayList;
import java.util.List;

public class JobEventVO  {


  public static enum JobEventType {
    CREATE("CREATE"),
    UPDATE("UPDATE"),
    DELETE("DELETE");

    private String value;
    
    JobEventType(String value) {
      this.value = value;
    }

    @Override
    public String toString() { return String.valueOf(value); }
  }

  private String jobId;

  // Project associated with the job
  private String projectId = null;

  // Group identifier
  private String groupId = null;

  private JobEventType type;

  private String state;

  private Long timestampType;

  // The timestamp of job submission
  private Long submissionTime = null;

  // Description
  private String description = null;

  // User that submitted the job
  private String jobOwner = null;

  // Algorithm specification
  private List<AlgorithmSpecificationVO> algorithms = new ArrayList<>();

  // Machine selected to execute
  private String executionMachine;

  // Machines selected by the user
  private List<String> selectedMachines = new ArrayList<>();

  // Priority
  private Integer priority = null;

  // The job exit code
  private Integer exitCode = null;

  // The status of the job after execution
  private String exitStatus = null;

  // The amount of CPU time used for processing the job
  private Long cpuTime = null;

  // The actual amount of time taken to run the job
  private Long wallclockTime = null;

  public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public JobEventType getType() {
    return type;
  }

  public void setType(JobEventType type) {
    this.type = type;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public Long getTimestampType() {
    return timestampType;
  }

  public void setTimestampType(Long timestampType) {
    this.timestampType = timestampType;
  }

  public Long getSubmissionTime() {
    return submissionTime;
  }

  public void setSubmissionTime(Long submissionTime) {
    this.submissionTime = submissionTime;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getJobOwner() {
    return jobOwner;
  }

  public void setJobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
  }

  public List<AlgorithmSpecificationVO> getAlgorithms() {
    return algorithms;
  }

  public void addAlgorithm(AlgorithmSpecificationVO as) {
    this.algorithms.add(as);
  }

  public String getExecutionMachine() {
    return executionMachine;
  }

  public void setExecutionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
  }

  public List<String> getSelectedMachines() {
    return selectedMachines;
  }

  public void setSelectedMachines(List<String> selectedMachines) {
    this.selectedMachines = selectedMachines;
  }

  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public Integer getExitCode() {
    return exitCode;
  }

  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }

  public String getExitStatus() {
    return exitStatus;
  }

  public void setExitStatus(String exitStatus) {
    this.exitStatus = exitStatus;
  }

  public Long getCpuTime() {
    return cpuTime;
  }

  public void setCpuTime(Long cpuTime) {
    this.cpuTime = cpuTime;
  }

  public Long getWallclockTime() {
    return wallclockTime;
  }

  public void setWallclockTime(Long wallclockTime) {
    this.wallclockTime = wallclockTime;
  }

  public String toJson(){
    return new Gson().toJson(this);
  }

}
