package br.pucrio.tecgraf.soma.job.event;

import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobRescheduledEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.JobStageInEvent;
import br.pucrio.tecgraf.soma.job.JobStageOutEvent;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;

public interface IJobHistoryEventFactory {

	/**
	 * Build an event to represent the uploading stage of a job.
	 * @param commandInfo containing csbase information for the related job.
	 * @return an instance of JobStageInEvent.
	 */
	JobStageInEvent buildStageInEvent(ICommandInfo commandInfo);

	/**
	 * Build an event to represent the downloading stage of a job.
	 * @param commandInfo containing csbase information for the related job.
	 * @return an instance of JobStageOutEvent.
	 */
	JobStageOutEvent buildStageOutEvent(ICommandInfo commandInfo);

	/**
	 * Build an event indicating that a job is being executed.
	 * @param commandInfo containing csbase information for the related job.
	 * @return an instance of JobExecutingEvent.
	 */
	JobExecutingEvent buildExecutingEvent(ICommandInfo commandInfo);
	
	/**
	 * Build an event indicating that a job was scheduled for execution.
	 * @param commandInfo containing csbase information for the related job.
	 * @return an instance of JobScheduledEvent.
	 */
	JobScheduledEvent buildScheduledEvent(ICommandInfo commandInfo);

	/**
	 * Build an event indicating that a job was rescheduled, after an execution attempt.
	 * @param commandInfo containing csbase information for the related job.
	 * @return an instance of JobRescheduledEvent.
	 */
	JobRescheduledEvent buildRescheduledEvent(ICommandInfo commandInfo);
	
	/**
	 * Build an event indicating that a job executing ended.
	 * @param commandInfo containing csbase information for the related job
	 * @return an instance of JobFinishedEvent.
	 */
	JobFinishedEvent buildFinishedEvent(ICommandInfo commandInfo);

}