/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.JobsviewApiService;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.factories.JobsviewApiServiceFactory;
import br.pucrio.tecgraf.soma.job.api.model.Error;
import br.pucrio.tecgraf.soma.job.api.model.JobViewResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.ServletConfig;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/jobsview")
@Api(description="the jobsview API")
public class JobsviewApi {
    private final JobsviewApiService delegate;

    public JobsviewApi(@Context ServletConfig servletContext) {
        String implClass;
        JobsviewApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("JobsviewApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (JobsviewApiService)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = JobsviewApiServiceFactory.getJobsviewApi();
        }
        this.delegate = delegate;
    }

    @GET
    @Produces(value={"application/json;", "application/json"})
    @ApiOperation(value="Fetch filtered list of jobs from view job_view.", notes="This endpoint list all jobs that match the parameters criteria", response=JobViewResponse.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=JobViewResponse.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=400, message="bad parameters. The error code are: <br> 1. If a invalid limit was used 2. If a invalid offset was used 3. If a invalid sort was used ", response=Error.class)})
    public Response jobsviewGet(@ApiParam(value="The query in RSQL format.") @QueryParam(value="q") String q, @ApiParam(value="The zero based position of the first item to retrieve") @QueryParam(value="offset") Integer offset, @ApiParam(value="The number of items to retrieve") @QueryParam(value="limit") Integer limit, @ApiParam(value="Parameter indicating the sorting direction of the results") @QueryParam(value="asc") Boolean asc, @ApiParam(value="Attribute that should be used to sort the results") @QueryParam(value="attr") String attr, @ApiParam(value="Add algorithm's parameter values.", defaultValue="true") @DefaultValue(value="true") @QueryParam(value="showParam") Boolean showParam, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsviewGet(q, offset, limit, asc, attr, showParam, locale, securityContext);
    }
}

